/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import java.net.URL;

/**
 * エンドポイント管理クラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class OutboundEndpoint {

    /**
     * エンドポイントのプロトコル。
     */
    private String protocol;

    /**
     * エンドポイントのホスト。
     */
    private String host;

    /**
     * エンドポイントのポート。
     */
    private int port;

    /**
     * エンドポイントのアプリケーションコンテキスト。
     * 
     */
    private String appcontext;

    /**
     * コンストラクタ。
     */
    public OutboundEndpoint() {
        super();
    }

    /**
     *エンドポイントの プロトコルを取得する。
     * 
     * @return エンドポイントのプロトコル。
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * エンドポイントのプロトコルを設定する。
     * 
     * @param protocol エンドポイントのプロトコル。
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * ホストを取得する。
     * 
     * @return ホスト。
     */
    public String getHost() {
        return host;
    }

    /**
     * ホストを設定する。
     * 
     * @param host ホスト。
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * エンドポイントのポートを取得する。
     * 
     * @return エンドポイントのポート。
     */
    public int getPort() {
        return port;
    }

    /**
     * エンドポイントのポートを設定する。
     * 
     * @param port エンドポイントのポート。
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * エンドポイントのアプリケーションコンテキストを取得する。
     * 
     * @return エンドポイントのアプリケーションコンテキスト。
     */
    public String getAppcontext() {
        return appcontext;
    }

    /**
     * エンドポイントのアプリケーションコンテキストを設定する。
     * 
     * @param appcontext エンドポイントのアプリケーションコンテキスト。
     */
    public void setAppcontext(String appcontext) {
        this.appcontext = appcontext;
    }

    /**
     * エンドポイントのURLを設定する。
     * 
     * @param url エンドポイントのURL。
     */
    public OutboundEndpoint(URL url) {
        super();
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.appcontext = url.getPath();
    }

    /**
     * コンストラクタ。
     * 
     * @param protocol エンドポイントのプロトコル。
     * @param host エンドポイントのホスト。
     * @param port エンドポイントのポート。
     * @param appcontext エンドポイントのアプリケーションコンテキスト。
     * @param path エンドポイントのパス。
     * @param method エンドポイントのメソッド。
     */
    public OutboundEndpoint(String protocol, String host, int port,
            String appcontext, String path, String method) {
        super();
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.appcontext = appcontext;
    }

    @Override
    public String toString() {
        String address = protocol + "://" + host + ":" + port + appcontext;
        return address;
    }
}
