/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.exception.EndPointMappingException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

/**
 * エンドポイントの変換テーブル(MAP)のビルダークラス.
 * 
 * @author ISP Shiraishi
 * 
 */
public class EndpointUrlBuilder {

    /**
     * ログメッセージ出力用オブジェクト。
     */
    private static final CitkLogger logger = CitkLogger
            .getLog(EndpointUrlBuilder.class);

    /**
     * エンドポイント定義。
     */
    private Map<String, String> settingDatas;

    /**
     * エンドポイント定義を取得する。
     * 
     * @return settingDatas エンドポイント定義。
     */
    public Map<String, String> getSettingDatas() {
        return settingDatas;
    }

    /**
     * エンドポイント定義を設定する。
     * 
     * @param settingDatas エンドポイント定義。
     */
    public void setSettingDatas(Map<String, String> settingDatas) {
        this.settingDatas = settingDatas;
    }

    /**
     * エンドポイントの変換テーブルを構築する。
     * 
     * @return エンドポイントの変換テーブル。
     */
    public Map<String, EndpointUrl> build() {
        Map<String, EndpointUrl> endpointURLMap = new HashMap<String, EndpointUrl>();
        for (String name : settingDatas.keySet()) {
            String[] urls = settingDatas.get(name).split(",");
            OutboundEndpoint permit = null;
            OutboundEndpoint deny = null;
            logger.debug("name : " + name + ", urls : "
                    + settingDatas.get(name));
            try {
                permit = new OutboundEndpoint(new URL(urls[0]));
                deny = new OutboundEndpoint(new URL(urls[1]));
            } catch (MalformedURLException e) {
                throw new EndPointMappingException(e,
                        "E-0201", null,
                        null, null);
            }

            EndpointUrl endpointUrl = new EndpointUrl();
            endpointUrl.setPermit(permit);
            endpointUrl.setDeny(deny);
            endpointURLMap.put(name, endpointUrl);
        }
        return endpointURLMap;
    }
}
