/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import java.util.Map;

import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpointResolver;

/**
 * アウトバウンドエンドポイント解決クラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class MemoryOutboundEndpointResolverImpl implements
        OutboundEndpointResolver {

    /**
     * エンドポイントのMAPビルダークラス。
     */
    private EndpointUrlBuilder endpointUrlBuilder;

    /**
     * エンドポイントMAPビルダークラスを取得する。
     * 
     * @return endpointUrlBuilder　エンドポイントMAPビルダークラス。
     */
    public EndpointUrlBuilder getEndpointUrlBuilder() {
        return endpointUrlBuilder;
    }

    /**
     * エンドポイントMAPビルダークラスを取得する。
     * 
     * @param endpointUrlBuilder ンドポイントMAPビルダークラス。
     */
    public void setEndpointUrlBuilder(EndpointUrlBuilder endpointUrlBuilder) {
        this.endpointUrlBuilder = endpointUrlBuilder;
    }

    /**
     * アウトバウンドエンドポイント解決メソッド。
     * 
     * @param targetKey ターゲットリソースを表すキー。
     * @param authzResult　認可結果。
     * @return エンドポイント情報。
     */
    @Override
    public OutboundEndpoint resolve(String targetKey, String authzResult) {
        // URLの論理 -> 物理変換
        Map<String, EndpointUrl> endpointUrls = null;
        endpointUrls = endpointUrlBuilder.build();
        if (endpointUrls.containsKey(targetKey) == false) {
            return null;
        }
        EndpointUrl endpointUrl = endpointUrls.get(targetKey);
        return endpointUrl.getOutboundEndpoint(authzResult);
    }
}
