/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

import org.junit.Test;

public class EndpointUrlTestCase {

    private static OutboundEndpoint permitEndpoint = new OutboundEndpoint(
            "http", "sp.citk201.com", 8080, "/sp1/test.html", "", "GET");
    private static OutboundEndpoint denyEndpoint = new OutboundEndpoint("http",
            "sp.citk202.com", 8080, "/sp1/test.html", "", "GET");

    @Test
    public void testGetOutboundEndpoint_permit() {
        EndpointUrl endpointUrl = new EndpointUrl();
        endpointUrl.setPermit(permitEndpoint);
        OutboundEndpoint permit = endpointUrl
                .getOutboundEndpoint(CitkConstants.AUTHZ_PERMIT);

        assertEquals(permitEndpoint, permit);
    }

    @Test
    public void testGetOutboundEndpoint_deny() {
        EndpointUrl endpointUrl = new EndpointUrl();
        endpointUrl.setDeny(denyEndpoint);
        OutboundEndpoint deny = endpointUrl
                .getOutboundEndpoint(CitkConstants.AUTHZ_DENY);

        assertEquals(denyEndpoint, deny);

    }
    
    @Test
    public void testGetOutboundEndpoint_indeterminate() {
        EndpointUrl endpointUrl = new EndpointUrl();
        endpointUrl.setDeny(denyEndpoint);
        OutboundEndpoint indeterminate = endpointUrl
                .getOutboundEndpoint(CitkConstants.AUTHZ_INDETERMINATE);

        assertEquals(denyEndpoint, indeterminate);

    }

    @Test(expected = CitkSystemException.class)
    public void testGetOutboundEndpoint_exception() {
        EndpointUrl endpointUrl = new EndpointUrl();
        endpointUrl.getOutboundEndpoint("hoge");
    }

}
