/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.net.MalformedURLException;
import java.net.URL;

import org.junit.Test;

public class OutboundEndpointTestCase {

    public static String protocol = "http";
    public static String host = "sp.citk201.com";
    public static int port = 8080;
    public static String appcontext = "/sp1/test/index.html";
    public static String path = "";
    public static String method = "GET";
    public static String urlString = protocol + "://" + host + ":" + port
            + appcontext;

    @Test
    public void testOutboundEndpointURL() {
        URL url = null;
        try {
            url = new URL(urlString);
        } catch (MalformedURLException e) {
            fail("テスト用URLが不正です");
        }

        OutboundEndpoint target = new OutboundEndpoint(url);

        assertEquals(target.getClass(), OutboundEndpoint.class);
    }

    @Test
    public void testOutboundEndpointStringStringIntStringStringString() {
        OutboundEndpoint target = new OutboundEndpoint(protocol, host, port,
                appcontext, path, method);

        assertEquals(target.getClass(), OutboundEndpoint.class);
    }

    @Test
    public void testToString() {
        OutboundEndpoint target = new OutboundEndpoint(protocol, host, port,
                appcontext, path, method);
        assertEquals(urlString, target.toString());
    }
}
