/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.exception.EndPointMappingException;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;

import org.junit.Test;

public class EndpointUrlBuilderTestCase {

    private static String key = "sp1/app";
    private static String permitUrl = "http://sp1.citk.com:8080/test/";
    private static String denyUrl = "http://sp1.citk.com:8080/test/error.html";


    @Test
    public void testBuild() throws Exception {
        EndpointUrlBuilder target = new EndpointUrlBuilder();

        Map<String, String> settingDatas;
        settingDatas = new HashMap<String, String>();
        settingDatas.put(key, permitUrl + "," + denyUrl);

        target.setSettingDatas(settingDatas);

        Map<String, EndpointUrl> result = target.build();

        EndpointUrl endpointUrl = result.get(key);
        assertEquals(permitUrl, endpointUrl.getPermit().toString());
        assertEquals(denyUrl, endpointUrl.getDeny().toString());
    }

    @Test(expected = EndPointMappingException.class)
    public void testBuild_exception() throws Exception {
        EndpointUrlBuilder target = new EndpointUrlBuilder();

        Map<String, String> settingDatas;
        settingDatas = new HashMap<String, String>();
        settingDatas.put(key, "notURLformat,notURLformat,notURLformat");

        target.setSettingDatas(settingDatas);

        // Exception発生
        target.build();

        fail("期待するExceptionが発生しませんでした。");
    }

}
