/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.exception.EndPointMappingException;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

import org.junit.Test;

public class MemoryOutboundEndpointResolverImplTestCase {

    private static EndpointUrlBuilder endpointUrlBuilder;
    private static Map<String, String> settingDatas;
    private static String key = "sp1/app";
    private static String permitUrl = "http://sp1.citk.com:8080/test/";
    private static String denyUrl = "http://sp1.citk.com:8080/test/error.html";

    static {
        settingDatas = new HashMap<String, String>();
        settingDatas.put(key, permitUrl + "," + denyUrl);
        endpointUrlBuilder = new EndpointUrlBuilder();
        endpointUrlBuilder.setSettingDatas(settingDatas);
    }

    @Test
    public void testResolve_permit() throws Exception {
        MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
        target.setEndpointUrlBuilder(endpointUrlBuilder);

        OutboundEndpoint permit = target.resolve(key,
                CitkConstants.AUTHZ_PERMIT);

        assertEquals(permitUrl, permit.toString());
    }

    @Test
    public void testResolve_deny() throws Exception {
        MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
        target.setEndpointUrlBuilder(endpointUrlBuilder);

        OutboundEndpoint deny = target.resolve(key, CitkConstants.AUTHZ_DENY);

        assertEquals(denyUrl, deny.toString());
    }

    @Test
    public void testResolve_indeterminate() throws Exception {
        MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
        target.setEndpointUrlBuilder(endpointUrlBuilder);

        OutboundEndpoint indeterminate = target.resolve(key,
                CitkConstants.AUTHZ_INDETERMINATE);

        assertEquals(denyUrl, indeterminate.toString());
    }

    @Test(expected = EndPointMappingException.class)
    public void testResolve_MalformedURLException() throws Exception {
        MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();

        Map<String, String> invalidSettingDatas = new HashMap<String, String>();
        invalidSettingDatas.put(key, "notURLFormat,notURLFormat,notURLFormat");
        EndpointUrlBuilder invalidUrlBuilder = new EndpointUrlBuilder();
        invalidUrlBuilder.setSettingDatas(invalidSettingDatas);

        target.setEndpointUrlBuilder(invalidUrlBuilder);

        // Exception発生
        target.resolve(key, CitkConstants.AUTHZ_PERMIT);

        fail("期待するExceptionが発生しませんでした。");
    }

    @Test
    public void testResolve_InvalidKey() {
        MemoryOutboundEndpointResolverImpl target = new MemoryOutboundEndpointResolverImpl();
        target.setEndpointUrlBuilder(endpointUrlBuilder);

        // permit
        target.resolve(key, CitkConstants.AUTHZ_PERMIT);

        // Exception発生
        OutboundEndpoint result = target.resolve("hoge", CitkConstants.AUTHZ_PERMIT);
        
        assertNull(result);

    }

}
