/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.app;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.CitkLogger;

import org.apache.commons.httpclient.Cookie;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;

public class CitkAppFedretErrorTestCase extends FunctionalTestCase {

    public CitkAppFedretErrorTestCase() {
        super();
        setFailOnTimeout(false);
    }

    /**
     * ログメッセージ出力用オブジェクト。
     */
    private static final CitkLogger logger = CitkLogger
            .getLog(CitkAppFedretErrorTestCase.class);

    private String relayState = null;
    
    @Override
    protected String getConfigResources() {
        return "mule-testFedletError-config.xml";
    }
    

    @Test
    public void testRequest_Idp202() throws Exception {
        
relayState = null;
        
        MuleClient client = new MuleClient(muleContext);
        
        //未認証状態からのリクエスト(RelayState取得)
        MuleMessage firstResponse = notAuthnUserFlow(client, null);

        // ID・PWの送信
        sendIDandPasswordFlow(client, firstResponse);

        // CITKのACSサービスへhttpPOSTリクエスト   //////Permit//////
        MuleMessage redirectToCitkResponse = acsRequestFlow(client, CitkConstants.AUTHZ_PERMIT);

        String status = redirectToCitkResponse.getInboundProperty(HttpConnector.HTTP_STATUS_PROPERTY);
        assertEquals("" + HttpConstants.SC_INTERNAL_SERVER_ERROR, status);
        
    }
    
    private Map<String, Object> getLoginFormRequest() {
        Map<String, Object> form = new LinkedHashMap<String, Object>();
        form.put("IDToken0", "");
        form.put("IDToken1", "test1");
        form.put("IDToken2", "testtest");
        form.put("IDButton", "Submit");
        form.put(
                "goto",
                "L1NTT1JlZGlyZWN0L21ldGFBbGlhcy9pZHAyMDE/UmVxSUQ9czJlM2JkNzUwODk2NjIwODk5ZjE3MWVlZTdmNTkxY2JlMzM5YzI3MmVk");
        form.put(
                "SunQueryParamsString",
                "cmVhbG09LyZmb3J3YXJkPXRydWUmU0FNTFJlcXVlc3Q9blZOTGo5b3dFTDd2cjRoOGh6eFFlRmlBUkVGVmtiYmRsS1E5OUZJWlo5SzFtdGlwWjdKTC8vM2EyU3lpNm9vRGx4d204L2hlWHFKbzZwWnZPbnJVQi9qVEFWSVFuSnBhSSsvL3JGaG5OVGNDRlhJdEdrQk9rdWViei9jOEdVZTh0WWFNTkRXNzIrOVdEQk9ZSE10WkdzMFgwMm5pdm9zcW5zVUFNS3ZTUlN5UE1Ka3NaREpMb0dUQmQ3Q29qRjR4dDRZRmU4UU85aHBKYUhLbEtFNUdVVHlLNHlLYThqVGk2ZlFIQzNZT210S0MrcWxIb3BhSG9TcmJzVlQwMjAyTXBXbjRQSnBIb1duQklmMjVTT013eng4T1VDb0xrc0lHU0d4cUpkQlB1UUVXZkRSV1FzOTh4U3BSSTNnZ21VQlVUM0N1WkFQRkQwcVhTdis2cnNmeHRRbjVwNkxJUnRsRFhyQmdnd2pXbzk0YWpWMEROZ2Y3cENSOE85eWZlZUFialdTZ0VjMURJWkd0NzViZUJkN3JZeTk4dVE1RHZKMWthM1JVazJWNHNXWFkyZkl2Ym02L3kweXQ1TjliUFBmNk5ZS3VkL3VLS2tkVjM4ckpDbzBLTkxFZ3ovejlyNTJvVmFYQXV2UjRwRTZ1dWpiUFd3dUNuQWRrTzJEclYvai9BajZ6R0VJTFpXK2swNWpnUkxldzJacW1GVmFoanhlY2hDUjN1SmZ0Y3ZHMmR0b2VvTHJGaXF0dGtrdS8ycFY5QUorTkxYM3dYRzZoTEx4b3JiRTAyUGdlbnJORzc4cmh4QXIvZitmckZ3PT0mUmVsYXlTdGF0ZT1hOTM5NGI2Ni0yMjVmLTQzNjEtODViMC1mZGQyMDkwMjk4MTMmc3BFbnRpdHlJRD1zcDIwMg==");
        form.put("encoded", "true");
        form.put("gx_charset", "UTF-8");
        return form;
    }

    private Map<String, Object> getACSFormRequest(String authzDecision) {
        Map<String, Object> form = new LinkedHashMap<String, Object>();
        if(authzDecision.equals(CitkConstants.AUTHZ_PERMIT)){
            form.put("SAMLResponse", "DummySAMLResponseOfPermit");
        }
        else if(authzDecision.equals(CitkConstants.AUTHZ_DENY)){
            form.put("SAMLResponse", "DummySAMLResponseOfDeny");
        }
        else{
            form.put("SAMLResponse", "DummySAMLResponseOfIndeterminate");
        }
        
        if(relayState != null && !relayState.isEmpty()){
            form.put("RelayState", relayState);
        }
        
        return form;
    }

    
    private MuleMessage notAuthnUserFlow(MuleClient client, String idpEntityID) throws Exception{
        MuleMessage firstRequest = new DefaultMuleMessage(null, muleContext);

        // 未認証状態でのリクエスト
        MuleMessage firstResponse = null;
        if(idpEntityID == null || idpEntityID.isEmpty()){
            firstResponse = client.send(
                    "http://localhost:8008/sp1/test/test.html", firstRequest);
        }
        else{
            firstResponse = client.send(
                    "http://localhost:8008/sp1/test/test.html?idpEntityId=" + idpEntityID,
                    firstRequest);
        }
        
        return firstResponse;
    }
    
    
    private MuleMessage sendIDandPasswordFlow(MuleClient client, MuleMessage firstResponse) throws Exception{
        
        // IdPへのリダイレクト
        String location = firstResponse.getInboundProperty(
                HttpConstants.HEADER_LOCATION, "");
        relayState = firstResponse
                .getSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY);
        MuleMessage redirectToIdpRequest = new DefaultMuleMessage(null,
                muleContext);
        
        
        MuleMessage loginFormHtmlResponse = client.send(location,
                redirectToIdpRequest);
        
        logger.warn("MESSAGE DUMP \n{0}",
                loginFormHtmlResponse.getPayloadAsString());
        
        Map<String, Object> loginForm = getLoginFormRequest();
        MuleMessage authnRequest = new DefaultMuleMessage(loginForm,
                muleContext);
        MuleMessage authnResponse = client.send(
                "http://localhost:8080/idp201/UI/Login", authnRequest);
        return authnResponse;
    }
    
    private MuleMessage acsRequestFlow(MuleClient client, String authzDecision) throws MuleException{
        Map<String, Object> acsForm = getACSFormRequest(authzDecision);
        MuleMessage redirectToACSRequest = new DefaultMuleMessage(acsForm,
                muleContext);
        MuleMessage redirectToCitkResponse = client.send(
                "http://localhost:8008/acs", redirectToACSRequest);
        return redirectToCitkResponse;
    }
    
    private MuleMessage authnUserRequestFlow(MuleClient client, MuleMessage redirectToCitkResponse) throws MuleException{
        MuleMessage lastRequest = new DefaultMuleMessage(null, muleContext);
        Cookie[] cookies = redirectToCitkResponse
                .getInboundProperty(HttpConstants.HEADER_COOKIE_SET);
        lastRequest.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);
        
        String url = null;
        if(relayState == null || relayState.isEmpty()){
            url = "http://localhost:8008/sp1/test/test.html";
        }
        else{
            url = "http://localhost:8008/sp1/test/test.html?RelayState=" + relayState;
        }
        MuleMessage lastResponse = client.send(url, lastRequest);
        
        return lastResponse;
    }

}
