/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.mock.fedlet;

import jp.co.ogis_ri.citk.common.CitkConstants;

import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;

public class AuthenticationRequestMockComponent implements Callable {

	private String location = "http://localhost:8080/IDP_ENTITY_ID/" +
			"SSORedirect/metaAlias/IDP_ENTITY_ID" +
			"?SAMLRequest=nVNLj9owEL7vr4h8hzgEBFiAREFVkbbdlNAeeqmMM%2BlaTezUM9ml%2F37t" +
			"QBHdXXHgOp7H9%2FIMZV01YtnSo9nCnxaQouhQVwZF9zJnrTPCStQojKwBBSmRLz%2Ffi0Gfi" +
			"8ZZsspW7G6znjMcFFxOgSdjSEfpdCz3UqUK9jwppjKdpMNhOVblcD8asug7ONTWzJlfw6INYg" +
			"sbgyQN%2BRJPBj2e9BK%2BS7jgiUjHP1i09tC0kdRNPRI1Io510fSVpt8DPugrW4sJn%2FDYN" +
			"uCR%2FpyOkjjPH7ZQaAeK4hpIListMUz5ARZ9tE5Bx3zOSlkhBCCZRNRPcK5kJ4oftCm0%2BX" +
			"Vdj%2F2xCcWn3S7rZQ%2F5jkVLRHAB9coabGtwObgnreDb9v7MA1%2FT4JNYKmSLu1lwQXT6u" +
			"AtfrsOQ%2F06yBQaqs%2Fhiy2lnI774uc06s5VWf2%2FxPOhXS7reHSq66JVdqyAnDWowxKI8" +
			"C%2Fe%2FtrLSpQbn03M0ZVlV9nnlQJL3gFwLbHGE%2Fz%2FgM4tTaKHojPQaExzoFjYrWzfSa" +
			"QzxgoNU5A93sl0uXlVe2y2Ut1hxtU0JFVb7cgjgs3VFCJ7PLRS7IFpjHZ1sfA%2FPWaN35fBi" +
			"xW%2F%2F%2BeIF"; 
	
	@Override
	public Object onCall(MuleEventContext eventContext) throws Exception {
		MuleMessage message = eventContext.getMessage();
		String idpEntityID = message.getInboundProperty(CitkConstants.IDP_ENTITYID_KEY);
		location = location.replaceAll("IDP_ENTITY_ID", idpEntityID);
		message.setOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY, HttpConstants.SC_MOVED_TEMPORARILY);
		message.setOutboundProperty(HttpConstants.HEADER_LOCATION, location);
		
		return message;
	}

	
}
