/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package manager;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * プロパティマネージャ.
 *
 */
public class PropsManager {

    private static final String PATH = "/testclient.properties";

    private static Properties props = new Properties();

    static {
        InputStream in = null;
        try {
            in = PropsManager.class.getResourceAsStream(PATH);
            props.load(in);

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            closeResource(in);
        }
    }

    /**
     * コンストラクタ.
     */
    private PropsManager() {
    }

    /**
     * プロパティ値を取得する.
     * 
     * @param key キー.
     */
    public static String getValue(String key) {
        return props.getProperty(key);
    }

    private static void closeResource(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        } catch (IOException e) {
            // no operation
        }
    }
}
