/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2009 Sun Microsystems Inc. All Rights Reserved
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at
 * https://opensso.dev.java.net/public/CDDLv1.0.html or
 * META-INF/CDDLv1.0.txt
 * See the License for the specific language governing
 * permission and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at META-INF/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * $Id: ClientHandler.java,v 1.5 2009/11/04 04:55:42 kamna Exp $
 *
 * --------------------------------------------------
 * Portions Copyrighted 2012 OGIS-RI Co., Ltd.
 */

package jp.co.ogis_ri.citk.wssagents.jaxws.client;

import static jp.co.ogis_ri.citk.common.CitkConstants.CITK_LOCALNAME;
import static jp.co.ogis_ri.citk.common.CitkConstants.CITK_NS;
import static jp.co.ogis_ri.citk.common.CitkConstants.CITK_PREFIX;
import static jp.co.ogis_ri.citk.common.CitkConstants.IDP_ENTITYID_KEY;
import static jp.co.ogis_ri.citk.common.CitkConstants.NAMEID_KEY;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import jp.co.ogis_ri.citk.common.log.CitkLogger;

import com.sun.identity.wss.security.WSSConstants;
import com.sun.identity.wss.security.handler.SOAPRequestHandler;
import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import com.sun.identity.wss.security.handler.ThreadLocalService;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;

/**
 * WS-Security
 * 
 */
public class ClientHandler implements SOAPHandler<SOAPMessageContext> {

    private static final CitkLogger logger =
            CitkLogger.getLog(ClientHandler.class);

    private String wscProfile;

    private Map<String, String> citkCredentials;

    /**
     * Gets the header blocks that can be processed by this Handler instance.
     * 
     * @return
     */
    public Set<QName> getHeaders() {
        Set<QName> qnames = new HashSet<QName>();
        qnames.add(new QName(WSSConstants.WSSE_NS,
                WSSConstants.WSSE_SECURITY_LNAME, WSSConstants.WSSE_TAG));
        return qnames;
    }

    /**
     * 
     * @param context
     */
    public boolean handleFault(SOAPMessageContext context) {
        logger.error("handleFault : "
                + context.getMessage().getSOAPPart().toString());
        return true;
    }

    /**
     * 
     * @param context
     */
    public boolean handleMessage(SOAPMessageContext context) {

        // Set the WSC provider name for WSC profile
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("providername", wscProfile);

        SOAPRequestHandlerInterface handler = new SOAPRequestHandler();
        try {
            handler.init(map);
        } catch (Exception ex) {
            logger.error(ex, "initialization failed.");
            throw new ProtocolException(ex);
        }

        // secureRequest/validateResponse parameter
        @SuppressWarnings("all")
        Map param = new HashMap();

        Boolean outboundMsg =
                (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outboundMsg.booleanValue()) {
            // outgoing Request process
            return handleOutgoingRequest(context, handler, param);
        } else {
            // incomming Response process
            return handleIncommingResponse(context, handler, param);
        }
    }

    @SuppressWarnings("all")
    private boolean handleIncommingResponse(SOAPMessageContext context,
            SOAPRequestHandlerInterface handler, Map param) {

        logger.debug("Incomming Response : "
                + handler.print(context.getMessage().getSOAPPart()));

        try {
            handler.validateResponse(context.getMessage(), param);
            return true;
        } catch (Exception ex) {
            logger.error(ex, "validateResponse failed.");
            throw new ProtocolException(ex.toString());
        }
    }

    @SuppressWarnings("all")
    private boolean handleOutgoingRequest(SOAPMessageContext context,
            SOAPRequestHandlerInterface handler, Map param) {

        logger.debug("Outgoing Request : "
                + handler.print(context.getMessage().getSOAPPart()));

        try {
            Subject subject = null;
            subject = (Subject) ThreadLocalService.getSubject();
            if (subject == null) {
                logger.debug("subject NULL");
                subject = new Subject();
            } else {
                ThreadLocalService.removeSubject();
            }
            setCredentialInfo(context);
            handler.secureRequest(context.getMessage(), subject, param);
            return true;
        } catch (Exception ex) {
            logger.error(ex, "secureRequest failed.");
            throw new ProtocolException(ex.toString());
        }
    }

    private void setCredentialInfo(SOAPMessageContext context)
            throws SOAPException {

        QName citk = new QName(CITK_NS, CITK_LOCALNAME, CITK_PREFIX);

        SOAPEnvelope envelope =
                context.getMessage().getSOAPPart().getEnvelope();
        if (envelope.getHeader() == null) {
            envelope.addHeader();
        }
        SOAPElement element = envelope.getHeader().addChildElement(citk);
        element.addChildElement(NAMEID_KEY).addAttribute(
                NameImpl.createFromTagName("value"),
                citkCredentials.get(NAMEID_KEY));
        element.addChildElement(IDP_ENTITYID_KEY).addAttribute(
                NameImpl.createFromTagName("value"),
                citkCredentials.get(IDP_ENTITYID_KEY));
    }

    /**
     * @param context
     */
    public void close(MessageContext context) {
        // No operation
    }

    public void setWscProfile(String wscProfile) {
        this.wscProfile = wscProfile;
    }

    public void setCitkCredentials(Map<String, String> citkCredentials) {
        this.citkCredentials = citkCredentials;
    }
}
