/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.wsp.cxf.interceptor;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;

import jp.co.ogis_ri.citk.wsp.cxf.jaxws.handler.AbstractWsHandler;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

import com.sun.identity.wss.security.WSSConstants;
import com.sun.identity.xmlenc.EncryptionConstants;

/**
 * The interceptor contributed to inbound request message or outbound response
 * message interceptor.
 * 
 */
public class WsInInterceptor extends AbstractPhaseInterceptor<SoapMessage>
        implements SoapInterceptor {

    private static final Set<QName> HEADERS = new HashSet<QName>();

    public static ThreadLocal<Subject> cred = new ThreadLocal<Subject>();

    public Subject subject = new Subject();

    private AbstractWsHandler handler;

    static {
        // WS-Security setting
        HEADERS.add(new QName(WSSConstants.WSSE_NS,
                WSSConstants.WSSE_SECURITY_LNAME));
        HEADERS.add(new QName(WSSConstants.WSSE11_NS,
                WSSConstants.WSSE_SECURITY_LNAME));

        // Encryption setting
        HEADERS.add(new QName(EncryptionConstants.ENC_XML_NS, "EncryptedData"));
    }

    /**
     * Constructor
     */
    public WsInInterceptor() {
        super(Phase.PRE_PROTOCOL);
    }

    public WsInInterceptor(AbstractWsHandler component) {
        this();
        this.handler = component;
    }

    /**
     * @param message
     */
    public void handleFault(SoapMessage message) {
        Set<QName> qnames = new HashSet<QName>();
        qnames.add(new QName(WSSConstants.WSSE_NS,
                WSSConstants.WSSE_SECURITY_LNAME, WSSConstants.WSSE_TAG));
    }

    /**
     * @param message
     */
    public void handleMessage(SoapMessage message) throws Fault {
        // validate REQUEST from Client
        handler.handleMessage(message, cred, subject);
    }

    /**
     * @return
     */
    public Set<URI> getRoles() {
        return Collections.emptySet();
    }

    /**
     * @return
     */
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    /**
     * 
     * @param handler
     */
    public void setHandler(AbstractWsHandler handler) {
        this.handler = handler;
    }
}
