#!/usr/bin/perl -w

use strict;
use File::Basename;
use vars qw(
	$SrcDir
	@Options
);

sub Select {
	my	($desc, $defaultNum, @list) = @_;
	my	$selected = undef;
	my	$failedTime = 0;

	while (!defined($selected) and $failedTime < 3) {
		my	$inputed;
		my	$i;

		print $desc,"\n";
		for ($i = 0; $i < scalar(@list); $i++) {
			printf "[%d] %s\n", $i+1, $list[$i]->{name};
		}

		print "Input number and type enter key";
		printf ' [%d]', $defaultNum	if ($defaultNum);
		print ': ';
		$inputed = <STDIN>;

		chomp $inputed;
		$inputed =~ s/^\s*(\S*)\s*$/$1/;
		if ($inputed =~ m/^[1-9]\d*$/) {
			if ($inputed <= $i) {
				$selected = $inputed;
			}
			else {
				printf "Available range is 1 to %d.\n", scalar(@list);
				$failedTime++;
			}
		}
		elsif ($defaultNum and $inputed eq '') {
			$selected = $defaultNum;
		}
		else {
			print "You can input only integer.\n";
			$failedTime++;
		}
		print "\n";
	}

	return $list[$selected-1]->{value}	if ($failedTime < 3);

	printf "Give up because it failed three times.\n";
	return undef;
}

if (! -d '/Applications/ClamXav.app') {
	print STDERR "ClamXav is not installed. Use install.sh\n";
	exit(1);
}

$SrcDir = dirname($0);
@Options = (
	qw(
		--verbose --admin-group=admin --prefix=/usr/local/clamXav
		--clamav-prefix=/usr/local/clamXav
	),
	'--clamd-restart=[qw(/Library/StartupItems/ClamAntiVirusDaemon/ClamAntiVirusDaemon restart)]',
	'--freshclam-restart=[qw(/Library/StartupItems/FreshClamDaemon/FreshClamDaemon restart)]'
);

push @Options, '--clamd'	if (-d '/Library/StartupItems/ClamAntiVirusDaemon');
push @Options, '--freshclam'	if (-d '/Library/StartupItems/FreshClamDaemon');

{
	my	$downloadFrom;

	$downloadFrom = Select("Select ClamAV mirror site", 1,
		{
			name	=> 'Japan Advanced Institute of Science and Technology (Ishikawa, Japan, JP)',
			value	=> 'http://jaist.dl.sourceforge.net/project/',
		},
		{
			name	=> 'National Central University (Taiwan, TW)',
			value	=> 'http://ncu.dl.sourceforge.net/project/',
		},
		{
			name	=> 'National Center for High-Performance Computing (Tainan, Taiwan, TW)',
			value	=> 'http://nchc.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Biznet Networks (Indonesia)',
			value	=> 'http://biznetnetworks.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Internode (Adelaide, Australia)',
			value	=> 'http://internode.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Waix (Perth, Australia)',
			value	=> 'http://waix.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Transact (Canberra, Australia)',
			value	=> 'http://waix.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Swedish University Computer Network (Sweden)',
			value	=> 'http://sunet.dl.sourceforge.net/project/',
		},
		{
			name	=> 'German Research Network (Berlin, Germany)',
			value	=> 'http://dfn.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Mesh Solutions (Duesseldorf, Germany, DE)',
			value	=> 'http://mesh.dl.sourceforge.net/project/',
		},
		{
			name	=> 'University of Kent (Kent, UK)',
			value	=> 'http://kent.dl.sourceforge.net/project/',
		},
		{
			name	=> 'SWITCH (Lausanne, Switzerland, CH)',
			value	=> 'http://jaist.dl.sourceforge.net/project/',
		},
		{
			name	=> 'HEAnet (Dublin, Ireland, IE)',
			value	=> 'http://heanet.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Free France (France, Europe)',
			value	=> 'http://freefr.dl.sourceforge.net/project/',
		},
		{
			name	=> 'OVH (Paris, France, FR)',
			value	=> 'http://ovh.dl.sourceforge.net/project/',
		},
		{
			name	=> 'garr.it (Bologna, Italy, it)',
			value	=> 'http://garr.dl.sourceforge.net/project/',
		},
		{
			name	=> 'iWeb (Montreal, Canada)',
			value	=> 'http://iweb.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Softlayer (Plano, TX, USA)',
			value	=> 'http://softlayer.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Voxel (New York, New York, US)',
			value	=> 'http://voxel.dl.sourceforge.net/project/',
		},
		{
			name	=> 'Centro de Computacao Cientifica e Software Livre (Curitiba, Brazil, BR)',
			value	=> 'http://ufpr.dl.sourceforge.net/project/',
		},
	);
	exit 2	unless (defined($downloadFrom));

	unless ($downloadFrom eq 'http://jaist.dl.sourceforge.net/project/') {
		push @Options, "--clamav-download-from=$downloadFrom";
	}

	$downloadFrom = Select("Select clamav-update mirror site", 1,
		{
			name	=> 'Tokyo Japan: OSDN Japan',
			value	=> 'http://osdn.dl.sourceforge.jp/clamav-update',
		},
		{
			name	=> 'Osaka Japan: GLOBALBASE',
			value	=> 'http://globalbase.dl.sourceforge.jp/clamav-update',
		},
		{
			name	=> 'Ishikawa Japan: Japan Advanced Institute of Science and Technology',
			value	=> 'http://jaist.dl.sourceforge.jp/clamav-update',
		},
		{
			name	=> 'Keihanna Japan: Kansai Science City Internet Community',
			value	=> 'http://keihanna.dl.sourceforge.jp/clamav-update',
		},
	);
	exit 3	unless (defined($downloadFrom));

	unless ($downloadFrom eq 'http://qgpop.dl.sourceforge.jp/clamav-update') {
		push @Options, "--download-from=$downloadFrom";
	}
}

system('/usr/bin/sudo', "$SrcDir/install.sh", @Options);
