// =====================================================================
//  $Id: Bt00RunSummary.cc,v 1.3 2003/10/06 16:28:14 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: Bt00RunSummary.cc,v $
//  Revision 1.3  2003/10/06 16:28:14  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "Bt00RunSummary.hh"

Bt00RunSummary::Bt00RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfCsIEvents( 0 ), 
    theNumberOfScalerEvents( 0 ),
    theNumberOfAllEvents( 0 ),
    theRunInformationTable(),
    theAccumulatedScaler( 8, 0 ),
    theRunBeginTime(),
    theRunEndTime()
{;}

Bt00RunSummary::~Bt00RunSummary()
{;}

Tvoid Bt00RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfCsIEvents = 0; 
  theNumberOfScalerEvents = 0;
  theNumberOfAllEvents = 0;
  theRunInformationTable.Clear();
  for ( Tsize_t i = 0; i < theAccumulatedScaler.size(); i ++ )
    theAccumulatedScaler[ i ] = 0;
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable Bt00RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "RUN ID", itostr( theRunID ) ) );
  infolist.push_back( TRunInformation( "RECORD PATH", theRecordName ) );
  infolist.push_back( TRunInformation( "RECORD SIZE", itostr( theRecordSize ) ) );
  infolist.push_back( TRunInformation( "RUN BEGIN", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "RUN END", theRunEndTime ) );
  infolist.push_back( TRunInformation( "CsI EVENTS", itostr( theNumberOfCsIEvents ) ) );
  infolist.push_back( TRunInformation( "SCALER EVENTS", itostr( theNumberOfScalerEvents ) ) );
  infolist.push_back( TRunInformation( "ALL EVENTS", itostr( theNumberOfAllEvents ) ) );
  infolist.push_back( TRunInformation( "PIN1", itostr( theAccumulatedScaler[ 0 ] ) ) );
  infolist.push_back( TRunInformation( "PIN2", itostr( theAccumulatedScaler[ 1 ] ) ) );
  infolist.push_back( TRunInformation( "PIN3", itostr( theAccumulatedScaler[ 2 ] ) ) );
  infolist.push_back( TRunInformation( "PIN4", itostr( theAccumulatedScaler[ 3 ] ) ) );
  infolist.push_back( TRunInformation( "PIN5", itostr( theAccumulatedScaler[ 4 ] ) ) );
  infolist.push_back( TRunInformation( "TRG1", itostr( theAccumulatedScaler[ 5 ] ) ) );
  infolist.push_back( TRunInformation( "TRG2", itostr( theAccumulatedScaler[ 6 ] ) ) );
  infolist.push_back( TRunInformation( "****", itostr( theAccumulatedScaler[ 7 ] ) ) );

  return theRunInformationTable + infolist;
}
