// =====================================================================
//  $Id: Rs01RunSummary.hh,v 1.4 2004/01/19 21:10:27 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: Rs01RunSummary.hh,v $
//  Revision 1.4  2004/01/19 21:10:27  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__RS01RUNSUMMARY_HH
#define CLDAQ__RS01RUNSUMMARY_HH

#include "TRunInformationTable.hh"

class Rs01RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    Rs01RunSummary();
    ~Rs01RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint Rs01RunSummary::GetRunID() const
{
  return theRunID;
}

inline const Tstring& Rs01RunSummary::GetRecordName() const
{
  return theRecordName;
}

inline Tint Rs01RunSummary::GetRecordSize() const
{
  return theRecordSize;
}

inline Tint Rs01RunSummary::GetNumberOfEvents() const
{
  return theNumberOfEvents;
}

inline const TRunInformationTable& Rs01RunSummary::GetRunInformationTable() const
{
  return theRunInformationTable;
}

inline const Tstring& Rs01RunSummary::GetRunBeginTime() const
{
  return theRunBeginTime;
}

inline const Tstring& Rs01RunSummary::GetRunEndTime() const
{
  return theRunEndTime;
}

inline Tvoid Rs01RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid Rs01RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid Rs01RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid Rs01RunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid Rs01RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid Rs01RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid Rs01RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

#endif
