// =====================================================================
//  $Id: sw01g4view.C,v 1.2 2004/03/08 12:11:08 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: sw01g4view.C,v $
//  Revision 1.2  2004/03/08 12:11:08  goiwai
//  sw01g4view.ccΥ󥿡ץ꥿(CINT)ǤǤ
//  ʬ˥饤ǤѤǤޤ
//  Run#0Υǡ1٥ɽˤ
//  root [0] .L sw01g4view.C
//  root [1] g4view("run000000.drec",1);
//
// =====================================================================
void g4view( const char* filename="run000000.drec", int update=1 )
{
  gROOT->Reset();
  if ( !gROOT->GetInterpreter()->IsLoaded("libIO.so") ) {
    gSystem->Load("libIO.so");
  }

  cv = new TCanvas( "cv", "Geant4 View" );
  cv -> SetFillColor(21);
  cv -> SetFrameFillColor(41);
  cv -> ToggleEventStatus();
  cv -> SetGridx();

  hist = new TH1D( "hist", "Beam Energy Spectrum", 6, 0, 6 );
  hist -> SetFillColor(33);
  hist -> GetXaxis() -> SetNdivisions(6);
  hist -> GetXaxis() -> CenterLabels();
  hist -> GetXaxis() -> SetTitle("CCD ID");
  hist -> GetYaxis() -> SetTitle("#DeltaE (MeV)");
  hist -> Draw();

  file = new TInputObjectFileOnline( filename );
  TDataRecord record;
  Tint n = 0;
  while ( file -> Read( record ) ) {
    if ( record == "EVENT" ) {
      Tdouble ccdid, edep;
      record[0][3][0].StorePrimitive(ccdid);
      record[0][3][1].StorePrimitive(edep);
      hist -> Fill( ccdid, edep );
      if ( update > 0 && n % update == 0 ) {
        cv -> Modified();
        cv -> Update();
      }
      n ++;
    } else if ( record == "RUN END" ) {
      break;
    }
  }

  cv->Modified();
  cv->Update();
  cv->cd();
}
