// =====================================================================
//  $Id: OFFspfast.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: OFFspfast.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St01OfflineDarkAverageMap.hh"
#include "St01OfflineDarkRmsMap.hh"
#include "St01SinglePixelInterface.hh"
#include "St01SinglePixelList.hh"
#include "St01DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dataset>" << Tendl;
    return -1;
  }

  TApplication* theApplication = rootinit();
  TCanvas cv( "CVfadc", "Pentland MPX201A", 900, 600 );
  cv.Divide( 2, 2 );
  TH1D signal( "signal", "Single Pixel Event", 100, 0.0, 500.0 );
  TH1D dark( "Ddark", "excluded D.C.", 50, -50.0, 50.0 );
  TH1D rms( "Drms", "RMS of D.C.", 20, 0.0, 50.0 );
  TH2D hBad( "Dbad", "Bad MAP", 256, 0.0, 256.0, 256, 0.0, 256.0 );
  //dark.SetFillColor( 46 );
  //rms.SetFillColor( 9 );
  //signal.SetFillColor( 28 );

  Tstring datasetf =  argv[ 1 ];
  St01SinglePixelInterface spif( datasetf );
  St01SinglePixelList splist = spif.GetSinglePixelList();
  for ( Tsize_t i = 0; i < splist.size(); i ++ ) {
    signal.Fill( splist[ i ].GetSignal() );
    dark.Fill( splist[ i ].GetDark() );
    rms.Fill( splist[ i ].GetRms() );
  }

  cv.cd( 1 );
  dark.Draw();
  cv.cd( 2 );
  rms.Draw();
  cv.cd( 3 );
  hBad.Draw( "colz" );
  cv.cd( 4 );
  gPad -> SetLogy();
  signal.Draw();
  cv.cd();

  theApplication -> Run();

  return 0;
}
