// =====================================================================
/*!
//
//  \file TExtractor.hh
//  \brief This file contains the TExtractor class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TExtractor.hh,v 1.6 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TExtractor.hh,v $
//  Revision 1.6  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TEXTRACTOR_HH
#define CLDAQ__TEXTRACTOR_HH

#include "Tglobals.h"
#include "TMatrixElement.hh"
#include "TDataElementList.hh"

class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TExtractor
// \brief This is the TExtractor class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TExtractor class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TExtractor
{

  protected:
    Tstring theExtractorID;
    TMatrixElement theMatrixElement;
    Tint theSamplingRate;
    Tbool theDataFoundStatus;
    Tbool theFillMatrixStatus;

  public:
    TExtractor( const Tstring& id, Tobject_t objecttype, Tint nevents = 0, Tint usec = 0 );
    virtual ~TExtractor();

  public:
    virtual Tvoid Extract() = 0;

  public:
    TDataSection FindDataSection( const TDataRecord& record, const Tstring& sectionid );
    TDataSegment FindDataSegment( const TDataSection& section, const Tstring& segmentid );
    TDataSegment FindDataSegment( const TDataRecord& record, const Tstring& sectionid, const Tstring& segmentid );
    TDataSegment FindDataSegment( const TDataRecord& record, Tstring id[ 2 ] );
    TDataElement FindDataElement( const TDataSegment& segment, const Tstring& elementid );
    TDataElement FindDataElement( const TDataRecord& record, const Tstring& sectionid, const Tstring& segmentid, const Tstring& elementid );
    TDataElement FindDataElement( const TDataRecord& record, Tstring id[ 3 ] );
    TDataElement FindDataElement( const TDataRecord& record, const TstringList& id );

  public:
    const TMatrixElement& GetMatrixElement() const;
    TMatrixElement& GetMatrixElement();
    Tvoid SetMatrixElement( const TMatrixElement& matrix );
    const Tstring& GetExtractorID() const;
    Tvoid SetExtractorID( const Tstring& id );
    Tint GetSamplingRate() const;
    Tvoid SetSamplingRate( Tint usec );
    Tbool DoesDataFound() const;
    Tbool DoesMatrixFill() const;
    Tbool DoesExtractSuccess() const;

  public:
    Tvoid FillMatrix( const TDataElementList& list );

  protected:
    Tvoid fillMatrixAs1DHistogram( const TDataElementList& list );
    Tvoid fillMatrixAs2DHistogram( const TDataElementList& list );
    Tvoid fillMatrixAsGraph( const TDataElementList& list );
    Tvoid fillMatrixAsNtuple( const TDataElementList& list );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TExtractor,0)
#endif

};

inline const TMatrixElement& TExtractor::GetMatrixElement() const
{
  return theMatrixElement;
}

inline TMatrixElement& TExtractor::GetMatrixElement()
{
  return theMatrixElement;
}

inline Tvoid TExtractor::SetMatrixElement( const TMatrixElement& matrix )
{
  theMatrixElement = matrix;
  return;
}

inline const Tstring& TExtractor::GetExtractorID() const
{
  return theExtractorID;
}

inline Tvoid TExtractor::SetExtractorID( const Tstring& id )
{
  theExtractorID = id;
  return;
}

inline Tbool TExtractor::DoesDataFound() const
{
  return theDataFoundStatus;
}

inline Tbool TExtractor::DoesMatrixFill() const
{
  return theFillMatrixStatus;
}

inline Tbool TExtractor::DoesExtractSuccess() const
{
  return DoesMatrixFill() && DoesDataFound();
}

inline Tint TExtractor::GetSamplingRate() const
{
  return theSamplingRate;
}

inline Tvoid TExtractor::SetSamplingRate( Tint usec )
{
  theSamplingRate = usec;
  return;
}

#endif
