// =====================================================================
//  $Id: TSleepCommand.cc,v 1.8 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TSleepCommand.cc,v $
//  Revision 1.8  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.7  2003/11/27 07:35:07  goiwai
//  *** empty log message ***
//
//  Revision 1.6  2003/11/25 05:09:44  goiwai
//  ThreadȤä˥꡼פƤޤ˽.
//
//  Revision 1.5  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/08/25 10:42:21  goiwai
//  Ǥ.äѤꥹåɤ˻ߤޤޤ.ߤޤ.
//  , /system/execute ʤ褦Ǥ.
//  ᡹,ľޤ.
//
//  Revision 1.3  2003/08/25 10:37:14  goiwai
//  sleep,åɤ˥꡼פƤޤΤ,ҥץä,
//  sleep褦ˤޤ.EventLoopư³ޤ.
//  ˤä,ʤˤ뤫Ȥ,
//  /run/start
//  /system/sleep 10
//  /run/suspend
//  /run/stop
//  Ȥäޥ򿩤碌뤳Ȥˤä,10äΥ¹ԤϤǤ.
//
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSleepCommand.hh"
#include "TRunManager.hh"
#include "TRegularExpression.hh"

static const Tstring _name = "/system/sleep";
static const Tstring _desc =
"Sleep a parent process."
"\n"
"Some thread processes go on."
"\n"
"This command can accept only one argument and must be digit."
"\n"
"CLDAQ> sleep 10";

TSleepCommand::TSleepCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSleepCommand::~TSleepCommand()
{;}

// TODO: Хå⡼ɤǼ¹ԤȤʤΤǤ
Tvoid TSleepCommand::Execute( const TstringList& arguments )
{
  static TRegularExpression regex( "^[0-9]+$" );

  if ( arguments.empty() ) {
    ShowCommandDetail();
  } else {
    Tstring strtime = arguments[ 0 ];
    if ( regex == strtime ) {
      sleep( strtoi( strtime ) );
    } else {
      ShowCommandDetail();
    }
  }

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TSleepCommand)
#endif
