// =====================================================================
//  $Id: TUnsetEnvironmentVariableCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TUnsetEnvironmentVariableCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TUnsetEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "unsetenv";
static const Tstring _desc = "deletes the variable from the table.\nexample> unsetenv ITEM";

TUnsetEnvironmentVariableCommand::TUnsetEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TUnsetEnvironmentVariableCommand::~TUnsetEnvironmentVariableCommand()
{;}

Tvoid TUnsetEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TUnsetEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcerr << head << "select no item." << Tendl;
    ShowCommandDetail();
  } else if ( arguments.size() == 1 ) {
    theEnvironmentVariableTable -> UnsetEnvironment( arguments[ 0 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TUnsetEnvironmentVariableCommand)
#endif
