// =====================================================================
/*!
//
//  \file TCrate.hh
//  \brief This file contains the TCrate class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCrate.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TCrate.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCRATE_HH
#define CLDAQ__TCRATE_HH

#include "Tglobals.h"
#include "TModuleTable.hh"

class TModule;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCrate
// \brief This is the TCrate class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCrate class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCrate
{

  private:
    TModuleTable theModuleTable;

  public:
    TCrate();
    ~TCrate();

  public:
    Tint InstallModule( TModule* module, const Tstring& id, const TstringList& group );
    Tint InstallModule( TModule* module, const Tstring& id, const Tstring& group = "" );
    Tint RemoveModule( Tint index );
    Tint RemoveModule( const Tstring& id );
    Tint RemoveModule( const TstringList& groups );
    Tvoid ClearCrate();
    TModule* FindModule( const Tstring& id );
    TModule* GetModule( Tint index );
    TModule* GetModule( const Tstring& id );

  public:
    const TModuleTable& GetModuleTable() const;
    TModuleTable& GetModuleTable();
    Tvoid SetModuleTable( const TModuleTable& table );

  public:
    Tvoid Clear();
    Tvoid Clear( const TstringList& groups );
    Tvoid Clear( const Tstring& group );
    Tvoid Update();
    Tvoid Update( const TstringList& groups );
    Tvoid Update( const Tstring& group );
    Tvoid Initialize();
    Tvoid Initialize( const TstringList& groups );
    Tvoid Initialize( const Tstring& group );
    Tvoid ClearAllModules();
    Tvoid UpdateAllModules();
    Tvoid InitializeAllModules();
    Tvoid ClearModule( const Tstring& id );
    Tvoid UpdateModule( const Tstring& id );
    Tvoid InitializeModule( const Tstring& id );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCrate,0)
#endif

};

inline const TModuleTable& TCrate::GetModuleTable() const
{
  return theModuleTable;
}

inline TModuleTable& TCrate::GetModuleTable()
{
  return theModuleTable;
}

inline Tvoid TCrate::SetModuleTable( const TModuleTable& table )
{
  theModuleTable = table;
  return;
}

#endif
