// ============================================================================
//  $Id: TOptionTable.cc,v 1.2 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TOptionTable.cc,v $
//  Revision 1.2  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2003/10/06 16:32:25  goiwai
//  GNUΰñˤľŪ˲᤹뤿ʤǤ.
//
// ============================================================================
#include "TOptionTable.hh"

static const TOption _help( "help", "h", TOption::tNeedNot, "display this help and exit" );
static const TOption _version( "version", "v", TOption::tNeedNot, "output version information and exit" );

TOptionTable::TOptionTable()
  : theOptionList()
{
  SetDefaultOption();
  dupcheck();
}

TOptionTable::TOptionTable( const TOptionList& options )
  : theOptionList( options )
{
  SetDefaultOption();
  dupcheck();
}

TOptionTable::TOptionTable( const TOption* options, Tint noption )
  : theOptionList()
{
  for ( Tint i = 0; i < noption; i ++ ) {
    theOptionList.push_back( options[ i ] );
  }
  SetDefaultOption();
  dupcheck();
}

TOptionTable::TOptionTable( const TOptionTable& right )
  : theOptionList( right.theOptionList )
{
  dupcheck();  
}

TOptionTable::~TOptionTable()
{;}

const TOptionTable& TOptionTable::operator=( const TOptionTable& right )
{
  theOptionList = right.theOptionList;
  dupcheck();
  return *this;
}

Tvoid TOptionTable::SetDefaultOption()
{
  theOptionList.push_back( _help );
  theOptionList.push_back( _version );
  dupcheck();
  return;
}

Tvoid TOptionTable::SetOption( const TOption& option )
{
  theOptionList.push_back( option );
  dupcheck();
  return;
}

Tvoid TOptionTable::dupcheck() const
{
  Tsize_t n = theOptionList.size();
  if ( n > 1 ) {
    for ( Tsize_t i = 0; i < n - 1; i ++ ) {
      for ( Tsize_t j = i + 1; j < n; j ++ ) {
        if ( theOptionList[ i ] == theOptionList[ j ] ) {
          CLDAQ_EXIT( "duplication options" );
        }
      }
    }
  }
  return;
}

Tostream& operator<<( Tostream& tos, const TOptionTable& right )
{
  for ( Tsize_t i = 0; i < right.theOptionList.size(); i ++ ) {  
    tos << right.theOptionList[ i ];
    if ( i != right.theOptionList.size() - 1 ) {
      tos << Tendl;
    }
  }
  tos << Tflush;
  return tos;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TOptionTable)
#endif
