// =====================================================================
/*!
//
//  \file TSystemClock.hh
//  \brief This file contains the TSystemClock class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSystemClock.hh,v 1.6 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TSystemClock.hh,v $
//  Revision 1.6  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSYSTEMCLOCK_HH
#define CLDAQ__TSYSTEMCLOCK_HH

#include "Tglobals.h"

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSystemClock
// \brief This is the TSystemClock class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSystemClock class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TSystemClock
{

  private:
    // elapsed time in second from 1970/1/1/00:00:00
    // ߻ʹ,ɬ theLastRequiredTime = theTime 줬Update()
    // ǤդλҤͤƤ⤳ϵʤ
    Tint theAllocatedTime;
    Tint theLastUpdateTime;
    Tint theTime;

  public:
    TSystemClock();
    TSystemClock( const TSystemClock& right );
    ~TSystemClock();

  public:
    const TSystemClock& operator=( const TSystemClock& right );
    friend Tostream& operator<<( Tostream& tos, const TSystemClock& right );

  public:
    Tstring WhatTimeIsItNow();
    Tstring WhatTimeIsIt( Tint second = -1 );
    Tstring WhenAllocated();
    Tstring WhenUpdate();
    Tint GetElapsedTime( const Tstring& unit = Tsec );
    Tint GetElapsedTimeOfLastUpdate( const Tstring& unit = Tsec );
    Tint GetYear( Tint second = -1 );
    Tint GetMonth( Tint second = -1 );
    Tint GetDay( Tint second = -1 );
    Tint GetHour( Tint second = -1 );
    Tint GetMinute( Tint second = -1 );
    Tint GetSecond( Tint second = -1 );
    Tint Update();

  public:
    Tint GetAllocatedTime() const;
    Tint GetLastUpdateTime() const;
    Tint GetTime() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSystemClock,0)
#endif

};

inline Tint TSystemClock::GetAllocatedTime() const
{
  return theAllocatedTime;
}

inline Tint TSystemClock::GetLastUpdateTime() const
{
  return theLastUpdateTime;
}

inline Tint TSystemClock::GetTime() const
{
  return theTime;
}

#endif
