// =====================================================================
//  $Id: getopt.cc,v 1.2 2003/10/10 09:26:36 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log
// =====================================================================
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  const Tstring usage =
    "getopt - Parse command line options as almost GNU style\n"
    "\n"
    "Usage: getopt [OPTION]... [FILE]...";

  TOptionList optionlist;
  optionlist.push_back( TOption( "all-option" ) );
  optionlist.push_back( TOption( "block-option", "B" ) );
  optionlist.push_back( TOption( "critical-option", 1 ) );
  optionlist.push_back( TOption( "destroy-option", 2 ) );
  optionlist.push_back( TOption( "element-option", "e", 0, "element description" ) );
  optionlist.push_back( TOption( "first-option", 1 ) );
  optionlist.push_back( TOption( "global-option" ) );
  optionlist.push_back( TOption( "human-option", "H", 0, "short option \"h\" is reserved by help option" ) );

  TArgument arg( argc, argv, TOptionTable( optionlist ), usage );
  Tcout << arg << Tendl;

  return 0;
}
