// =====================================================================
//  $Id: Rs01RunSummary.cc,v 1.3 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: Rs01RunSummary.cc,v $
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "Rs01RunSummary.hh"

Rs01RunSummary::Rs01RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ), 
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

Rs01RunSummary::~Rs01RunSummary()
{;}

Tvoid Rs01RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0; 
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable Rs01RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "RUN ID", itostr( theRunID, 0 ) ) );
  infolist.push_back( TRunInformation( "RECORD PATH", theRecordName ) );
  infolist.push_back( TRunInformation( "RECORD SIZE", itostr( theRecordSize, 0 ) ) );
  infolist.push_back( TRunInformation( "RUN BEGIN", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "RUN END", theRunEndTime ) );
  infolist.push_back( TRunInformation( "EVENTS", itostr( theNumberOfEvents, 0 ) ) );

  return theRunInformationTable + infolist;
}
