// =====================================================================
//  $Id: St01DarkDataSet.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: St01DarkDataSet.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St01DarkDataSet.hh"

St01DarkDataSet::St01DarkDataSet( Tdouble temp, Tdouble cycle, Tdouble v, Tdouble ave, Tdouble rms, Tdouble ndata, Tint nbad, const Tstring& file )
  : theTemperature( temp ),
    theCycle( cycle ),
    theVoltage( v ),
    theAverage( ave ),
    theRms( rms ),
    theNumberOfData( ndata ),
    theNumberOfBadChannels( nbad ),
    theFileName( file )
{;}

St01DarkDataSet::St01DarkDataSet( const St01DarkDataSet& right )
  : theTemperature( right.theTemperature ),
    theCycle( right.theCycle ),
    theVoltage( right.theVoltage ),
    theAverage( right.theAverage ),
    theRms( right.theRms ),
    theNumberOfData( right.theNumberOfData ),
    theNumberOfBadChannels( right.theNumberOfBadChannels ),
    theFileName( right.theFileName )
{;}

St01DarkDataSet::~St01DarkDataSet()
{;}

const St01DarkDataSet& St01DarkDataSet::operator=( const St01DarkDataSet& right )
{
  theTemperature = right.theTemperature;
  theCycle = right.theCycle;
  theVoltage = right.theVoltage;
  theAverage = right.theAverage;
  theRms = right.theRms;
  theNumberOfData = right.theNumberOfData;
  theNumberOfBadChannels = right.theNumberOfBadChannels;
  theFileName = right.theFileName;
  return *this;
}

Tostream& operator<<( Tostream& tos, const St01DarkDataSet& right )
{
  tos << right.theTemperature << Tspace;
  tos << right.theCycle << Tspace;
  tos << right.theVoltage << Tspace;
  tos << right.theAverage << Tspace;
  tos << right.theRms << Tspace;
  tos << right.theNumberOfData << Tspace;
  tos << right.theNumberOfBadChannels << Tspace;
  tos << right.theFileName << Tflush;
  return tos;
}

Tistream& operator>>( Tistream& tis, St01DarkDataSet& right )
{
  tis >> right.theTemperature >> right.theCycle >> right.theVoltage;
  tis >> right.theAverage >> right.theRms >> right.theNumberOfData;
  tis >> right.theNumberOfBadChannels >> right.theFileName;
  return tis;
}
