// =====================================================================
/*!
//
//  \file TCompressObjectFilter.hh
//  \brief This file contains the TCompressObjectFilter class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCompressObjectFilter.hh,v 1.9 2004/03/07 16:52:34 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TCompressObjectFilter.hh,v $
//  Revision 1.9  2004/03/07 16:52:34  goiwai
//  __CLDAQ_ZLIB_USEץץåΰ֤äȤ餷Ǥ
//
//  Revision 1.8  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.7  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.6  2003/12/06 10:50:44  goiwai
//  ĵդʰ̥ե륿Ǥ.
//  ȴμʤΤǤޤեˤбƤޤ,2ܰʾ®ǽ
//  夷ޤ.
//
*/
// =====================================================================
#ifdef __CLDAQ_ZLIB_USE
#ifndef CLDAQ__TCOMPRESSOBJECTFILTER_HH
#define CLDAQ__TCOMPRESSOBJECTFILTER_HH

#include "Tglobals.h"
#include "TOutputObjectFilter.hh"
#include "TDataDeflation.hh"

class TStreamableObject;
class TOutputObjectStream;
class TObjectStream;

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCompressObjectFilter
// \brief This is the TCompressObjectFilter class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCompressObjectFilter class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TCompressObjectFilter
  : public TOutputObjectFilter
{

  private:
    TDataDeflation theEncoder;

  public:
    TCompressObjectFilter();
    ~TCompressObjectFilter();

  public:
    Tint Filtering( TStreamableObject& object, TOutputObjectStream* stream );
    Tvoid Initialize( TOutputObjectStream* stream );
    Tvoid Finalize( TOutputObjectStream* stream );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCompressObjectFilter,0)
#endif

};

#endif
#endif
