// =====================================================================
/*!
//
//  \file TInputObjectStream.hh
//  \brief This file contains the TInputObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectStream.hh,v 1.8 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TInputObjectStream.hh,v $
//  Revision 1.8  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.7  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.6  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.5  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/11 02:56:14  goiwai
//  ǥȥ饯 protected  public °ѹޤ.餳
//  ʤ,ؤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TINPUTOBJECTSTREAM_HH
#define CLDAQ__TINPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TInputObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectStream
// \brief This is the TInputObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectStream
  : public TObjectStream
{

  protected:
    TInputObjectFilter* theObjectFilter;

  public:
    TInputObjectStream( Tstream_t streamtype = tUnknownStream );
    TInputObjectStream( TInputObjectFilter* filter, Tstream_t streamtype = tUnknownStream );
    virtual ~TInputObjectStream();

  public:
    TInputObjectFilter* GetObjectFilter() const;
    Tvoid SetObjectFilter( TInputObjectFilter* filter );
    Tbool HasFilter() const;

  public:
    virtual Tint Read( TStreamableObject& object ) = 0;
    friend Tint operator>>( TInputObjectStream& left, TStreamableObject& object );
    friend Tint operator>>( TInputObjectStream& left, const TStreamableObject& object );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TInputObjectStream,0)
#endif

};

inline Tint operator>>( TInputObjectStream& left, TStreamableObject& object )
{
  return left.Read( object );
}

inline Tint operator>>( TInputObjectStream& left, const TStreamableObject& object )
{
  return left.Read( *(TStreamableObject*)(&object) );
}

inline TInputObjectFilter* TInputObjectStream::GetObjectFilter() const
{
  return theObjectFilter;
}

inline Tvoid TInputObjectStream::SetObjectFilter( TInputObjectFilter* filter )
{
  theObjectFilter = filter;
  return;
}

inline Tbool TInputObjectStream::HasFilter() const
{
  return ( theObjectFilter != 0 ) ? Ttrue : Tfalse;
}

#endif
