// =====================================================================
//  $Id: Sw01CrateDefinition.cc,v 1.1 2004/03/01 09:48:29 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: Sw01CrateDefinition.cc,v $
//  Revision 1.1  2004/03/01 09:48:29  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "Sw01CrateDefinition.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareFlashAdcModule.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareDataFileModule.hh"
#include "TRunInformationTable.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "TEnvironmentVariableTable.hh"

Sw01CrateDefinition::Sw01CrateDefinition()
  : TCrateDefinition()
{;}

Sw01CrateDefinition::~Sw01CrateDefinition()
{;}

TCrate* Sw01CrateDefinition::Define()
{
  const TEnvironmentVariableTable& envtable = 
    TRunManager::GetRunManager() -> GetEnvironmentVariableTable();
  Tint freq = envtable.GetIntegerValue( "SW01_INTERRUPT_FREQUENCY" );



  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "REAL RUN" );
  selectlist.push_back( "SOFTWARE RUN" );
  selectlist.push_back( "SIMULATION RUN" );
  selectlist.push_back( "TEST RUN" );
  selectlist.push_back( "DUMMY RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  selectlist.clear();
  selectlist.push_back( "1.0 MeV" );
  selectlist.push_back( "10.0 MeV" );
  selectlist.push_back( "100.0 MeV" );
  selectlist.push_back( "1.0 GeV" );
  selectlist.push_back( "10.0 MeV" );
  selectlist.push_back( "100.0 MeV" );
  infolist.push_back( TRunInformation( "BEAM ENERGY", selectlist ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable table( infolist );


  TCrate* crate = new TCrate();

  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Run ID", "run begin initialize" );
  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Event ID", "run begin initialize" );


  TSoftwareRunInformationModule* runinfo = new TSoftwareRunInformationModule( table );
  crate -> InstallModule( runinfo, "Run Information" );
  TRunManager::GetRunManager() -> SetRunInformationModule( runinfo );

  crate -> InstallModule( new TSoftwareClockModule( 1 ), "Clock", "run begin initialize" );
  crate -> InstallModule( new TSoftwareTimerModule( Tusec, 1 ), "Timer", "run begin initialize" );
  crate -> InstallModule( new TSoftwareFlashAdcModule(), "Flash ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareAdcModule(), "ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareInterruptRegisterModule( 1, freq ), "Interrupt Register", "run begin initialize" );
  crate -> InstallModule( new TSoftwareDataFileModule( "sw01.g4dat", 2 ), "Geant4", "run begin initialize" );

  return crate;
}
