// =====================================================================
//  $Id: St02DarkDataSet.hh,v 1.5 2004/01/19 21:10:29 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: St02DarkDataSet.hh,v $
//  Revision 1.5  2004/01/19 21:10:29  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/09/07 02:36:07  goiwai
//  󥹥ȥ饯ѹޤ.
//  ˥ե̾Ȥä,Υե뤫鲹پʤɤäƤƤ
//  ΤǤ,ǡ쥳ɤ˽񤭹ޤ줿ͤ򿮤褦ˤޤ.
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST02DARKDATASET_HH
#define CLDAQ__ST02DARKDATASET_HH

#include "Tglobals.h"

class St02DarkDataSet
{

  private:
    Tdouble theTemperature;
    Tdouble theAccumulationTime;
    Tdouble theVerticalShiftVoltage;
    Tdouble theConstant;
    Tdouble theMean;
    Tdouble theSigma;
    Tdouble theErrorOfConstant;
    Tdouble theErrorOfMean;
    Tdouble theErrorOfSigma;

  public:
    St02DarkDataSet( Tdouble temp = 0.0, Tdouble atime = 0.0, Tdouble vshift = 0.0, Tdouble constant = 0.0, Tdouble mean = 0.0, Tdouble sigma = 0.0, Tdouble constant_e = 0.0, Tdouble mean_e = 0.0, Tdouble sigma_e = 0.0 );
    St02DarkDataSet( Tdouble* pars );
    St02DarkDataSet( const St02DarkDataSet& right );
    ~St02DarkDataSet();

  public:
    const St02DarkDataSet& operator=( const St02DarkDataSet& right );
    friend Tostream& operator<<( Tostream& tos, const St02DarkDataSet& right );
    friend Tistream& operator>>( Tistream& tis, St02DarkDataSet& right );

  public:
    Tdouble GetTemperature() const;
    Tdouble GetAccumulationTime() const;
    Tdouble GetVerticalShiftVoltage() const;
    Tdouble GetConstant() const;
    Tdouble GetMean() const;
    Tdouble GetSigma() const;
    Tdouble GetErrorOfConstant() const;
    Tdouble GetErrorOfMean() const;
    Tdouble GetErrorOfSigma() const;

};

inline Tdouble St02DarkDataSet::GetTemperature() const
{
  return theTemperature;
}

inline Tdouble St02DarkDataSet::GetAccumulationTime() const
{
  return theAccumulationTime;
}

inline Tdouble St02DarkDataSet::GetVerticalShiftVoltage() const
{
  return theVerticalShiftVoltage;
}

inline Tdouble St02DarkDataSet::GetConstant() const
{
  return theConstant;
}

inline Tdouble St02DarkDataSet::GetMean() const
{
  return theMean;
}

inline Tdouble St02DarkDataSet::GetSigma() const
{
  return theSigma;
}

inline Tdouble St02DarkDataSet::GetErrorOfConstant() const
{
  return theErrorOfConstant;
}

inline Tdouble St02DarkDataSet::GetErrorOfMean() const
{
  return theErrorOfMean;
}

inline Tdouble St02DarkDataSet::GetErrorOfSigma() const
{
  return theErrorOfSigma;
}

#endif
