// =====================================================================
//  $Id: St02EventAction.cc,v 1.4 2004/03/04 15:11:56 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: St02EventAction.cc,v $
//  Revision 1.4  2004/03/04 15:11:56  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"

#include "St02EventAction.hh"
#include "St02RunAction.hh"
#include "St02RunSummary.hh"

St02EventAction::St02EventAction()
{;}

St02EventAction::~St02EventAction()
{;}

TReadoutList* St02EventAction::WaitTrigger()
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST02_RPV130_OUT_VETO" );
  Tint open = envtable.GetIntegerValue( "ST02_RPV130_OUT_OPEN" );
  Tint t = envtable.GetIntegerValue( "ST02_EVENTLOOP_USLEEP" );

  Tbool trigger = Tfalse;

  do {
    if ( mpx201a -> IsMemoryBlockFull() ) {
      trigger = Ttrue;
    } else {
      usleep( t );
      continue;
    }
  } while ( trigger == Tfalse );

  rpv130 -> LevelUp( veto );
  rpv130 -> Pulse( open );

  //mpx201a -> SetBufferOrientation( 1 );
  return theReadoutBook -> GetReadoutList( "EVENT" );
}

Tvoid St02EventAction::AtFirst( TEvent& anEvent )
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST02_RPV130_OUT_VETO" );

  mpx201a -> EnableAcquisition();

  rpv130 -> LevelDown( veto );

  return;
}

Tvoid St02EventAction::AtLast( TEvent& anEvent )
{
  St02RunAction* action =
    (St02RunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );


  TDataRecord record = anEvent.GetDataRecord();
  ofile -> Write( record );

  fillEventInformation( record );

  theCrate -> Update( "event" );


  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint stop = envtable.GetIntegerValue( "ST02_RPV130_OUT_STOP" );

  mpx201a -> NextEventProcedure();
  rpv130 -> Pulse( stop );
  return;
}

Tvoid St02EventAction::fillEventInformation( const TDataRecord& record )
{
  St02RunAction* action = (St02RunAction*)( theRunManager -> GetRunAction() );
  St02RunSummary* summary = action -> GetRunSummary();
  Tint nevent = summary -> GetNumberOfEvents();
  summary -> SetNumberOfEvents( ++ nevent );

  return;
}
