// =====================================================================
//  $Id: St02RunAction.hh,v 1.5 2004/03/04 15:11:56 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: St02RunAction.hh,v $
//  Revision 1.5  2004/03/04 15:11:56  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.4  2004/01/19 21:10:29  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST02RUNACTION_HH
#define CLDAQ__ST02RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class St02RunSummary;

class St02RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    St02RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    St02RunAction();
    ~St02RunAction();

  public:
    Tvoid Start( TRun& aRun );
    Tvoid Stop( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    St02RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* St02RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline St02RunSummary* St02RunAction::GetRunSummary() const
{
  return theRunSummary;
}

inline TOutputHtmlFileStream& St02RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

#endif
