// =====================================================================
//  $Id: st02OFFdump.cc,v 1.1 2003/11/04 12:01:40 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: st02OFFdump.cc,v $
//  Revision 1.1  2003/11/04 12:01:40  goiwai
//  CCDΥǡʬΤߤפޤ.
//
// =====================================================================
#include "TOption.hh"
#include "TArgument.hh"
#include "TEnvironmentVariableTable.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  TOption oprun( "run-number", 1 );
  TArgument arg( argc, argv, TOptionTable( &oprun ) );

  if ( !arg.HasOption( oprun ) ) {
    arg.ShowUsage();
  }

  TEnvironmentVariableTable envtable( "st02setup" );
  Tstring rechead = envtable.GetEnvironmentValue( "ST02_RECORD_HEAD" );
  Tstring recpath = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" );
  Tstring stringid = itostr( arg.GetIntegerParameter( oprun ) );
  Tstring filename = recpath + Tslash + rechead + stringid + ".drec";

  TDataRecord record;
  TInputObjectFile ifile( filename );
  while ( ( ifile.Read( record ) ) != 0 ) {
    if ( record == "EVENT" ) {
      TDataElement e = record[1][0][0];
      const Tint ndata = e.GetNumberOfPrimitives();
      Tshort* buf = new Tshort[ ndata ];
      e.StorePrimitives( buf );
      for ( Tint i = 0; i < ndata; i ++ ) {
        Tcout << i << ": " << buf[i] << Tendl;
      }
      delete [] buf;
    }
  }

  return 0;
}
