// ============================================================================
//  $Id: TRecordDisplayTab.cc,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TRecordDisplayTab.cc,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#include "TRecordDisplayTab.hh"
#include "TRecordDisplay.hh"
#include "TRecordDisplayPreference.hh"

static const Tsize_t _maxlen = 0x10;
static const Tstring _dots = "...";

TRecordDisplayTab::TRecordDisplayTab( TRecordDisplay* d )
  : TRecordDisplayComponent( d ), 
    TGTab( theRecordDisplay, 0, 0 )
{
  Build();
}

TRecordDisplayTab::TRecordDisplayTab( TRecordDisplay* d, TGCompositeFrame* p )
  : TRecordDisplayComponent( d, p ), 
    TGTab( theParentFrame, 0, 0 )
{
  Build();
}

TRecordDisplayTab::~TRecordDisplayTab()
{
  // ȻҤɤä
}


Tstring TRecordDisplayTab::GetTabText( const Tstring& title ) const
{
  Tstring tabtext = title;

  // ɬװʾĹʸϥå
  if ( tabtext.size() > _maxlen ) {
    tabtext = tabtext.substr( 0, _maxlen - _dots.size() );
    tabtext += _dots;
  }

  return tabtext;
}

TGCompositeFrame* TRecordDisplayTab::GetFrame( const Tstring& title )
{
  Tstring tabtext = GetTabText( title );

  Tint index = 0;
  for ( Tint i = 0; i < GetNumberOfTabs(); i ++ ) {
    TGTabElement* e = GetTabTab( i );
    Tstring text = e -> GetText() -> GetString();
    if ( text == tabtext ) {
      return GetTabContainer(i);
    }
    index ++;
  }

  // ޤ֥СĤƤʤä鿷ˤĤƤΥե졼֤
  return AddTab( tabtext.c_str() );
}

TRecordDisplayTab* TRecordDisplayTab::GetTab( TGCompositeFrame* frame )
{
  // ե졼ˤ륿֤֤,
  TIter next( frame->GetList() );
  TGFrameElement* el = 0;
  while ( ( el = (TGFrameElement*)next() ) ) {
    TGFrame* f = el -> fFrame;
    Tstring cname = f -> ClassName();
    if ( cname == "TGTab" ) {
      return (TRecordDisplayTab*)f;
    }
  }

  // ʤ褦ʤ newAddFrame
  TRecordDisplayTab* newtab = new TRecordDisplayTab( theRecordDisplay, frame );
  return newtab;
}

Tvoid TRecordDisplayTab::Build()
{
  TGLayoutHints* tabL = 
    theRecordDisplay -> GetPreference() -> GetTabLayoutHint();
  theParentFrame -> AddFrame( this, tabL );

  //theParentFrame -> MapSubwindows();
  //theParentFrame -> Layout();
  //theParentFrame -> MapWindow();

  theFinishBuild = Ttrue;

  return;
}

#endif

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRecordDisplayTab)
#endif
