// =====================================================================
/*!
//
//  \file TCommandSpecified.hh
//  \brief This file contains the TCommandSpecified class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCommandSpecified.hh,v 1.6 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TCommandSpecified.hh,v $
//  Revision 1.6  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:11  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCOMMANDSPECIFIED_HH
#define CLDAQ__TCOMMANDSPECIFIED_HH

#include "Tglobals.h"

class TCommand;



/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCommandSpecified
// \brief This is the TCommandSpecified class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCommandSpecified class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup CommandsCategory
*/
class TCommandSpecified
{
  public:
    enum { 
      tBuiltinDepth = -1, 
      tAliasDepth = -2, 
      tNotDefineDepth = 0x8fffffff
    };

  private:
    Tstring theName;
    Tstring theFullName;
    Tstring theAbsolutePath;
    Tint theDirectoryDepth;
    Tbool theBuiltinFlag;
    TCommand* theCommand;

  public:
    TCommandSpecified();
    TCommandSpecified( const Tstring& name, const Tstring& fullname, const Tstring& path, Tint depth, Tbool flag, TCommand* command );
    TCommandSpecified( const TCommandSpecified& right );
    ~TCommandSpecified();

  public:
    const TCommandSpecified& operator=( const TCommandSpecified& right );
    Tbool operator==( const TCommandSpecified& right ) const;
    Tbool operator!=( const TCommandSpecified& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TCommandSpecified& right );

  public:
    const Tstring& GetName() const;
    const Tstring& GetFullName() const;
    const Tstring& GetAbsolutePath() const;
    Tint GetDirectoryDepth() const;
    Tbool IsBuiltinCommand() const;
    Tbool IsAliasedCommand() const;
    TCommand* GetCommand() const;
    Tvoid SetName( const Tstring& name );
    Tvoid SetFullName( const Tstring& name );
    Tvoid SetAbsolutePath( const Tstring& path );
    Tvoid SetDirectoryDepth( Tint depth );
    Tvoid SetBuiltinFlag( Tbool flag );
    Tvoid SetCommand( TCommand* command );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCommandSpecified,0)
#endif

};

inline const Tstring& TCommandSpecified::GetName() const
{
  return theName;
}

inline const Tstring& TCommandSpecified::GetFullName() const
{
  return theFullName;
}

inline const Tstring& TCommandSpecified::GetAbsolutePath() const
{
  return theAbsolutePath;
}

inline Tint TCommandSpecified::GetDirectoryDepth() const
{
  return theDirectoryDepth;
}

inline Tbool TCommandSpecified::IsBuiltinCommand() const
{
  return theBuiltinFlag;
}

inline Tbool TCommandSpecified::IsAliasedCommand() const
{
  return theDirectoryDepth == tAliasDepth;
}

inline TCommand* TCommandSpecified::GetCommand() const
{
  return theCommand;
}

inline Tvoid TCommandSpecified::SetName( const Tstring& name )
{
  theName = name;
  return;
}

inline Tvoid TCommandSpecified::SetFullName( const Tstring& name )
{
  theFullName = name;
  return;
}

inline Tvoid TCommandSpecified::SetAbsolutePath( const Tstring& path )
{
  theAbsolutePath = path;
  return;
}

inline Tvoid TCommandSpecified::SetDirectoryDepth( Tint depth )
{
  theDirectoryDepth = depth;
  return;
}

inline Tvoid TCommandSpecified::SetBuiltinFlag( Tbool flag )
{
  theBuiltinFlag = flag;
  return;
}

inline Tvoid TCommandSpecified::SetCommand( TCommand* command )
{
  theCommand = command;
  return;
}

#endif
