// =====================================================================
//  $Id: TPrintCurrentWorkingDirectoryCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TPrintCurrentWorkingDirectoryCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TPrintCurrentWorkingDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "pwd";
static const Tstring _desc = "print the absolute pathname of the current working directory.";

TPrintCurrentWorkingDirectoryCommand::TPrintCurrentWorkingDirectoryCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TPrintCurrentWorkingDirectoryCommand::~TPrintCurrentWorkingDirectoryCommand()
{;}

Tvoid TPrintCurrentWorkingDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  static const Tstring head = "TPrintCurrentWorkingDirectoryCommand::Execute: ";
  if ( ui ) {
    Tcout << ui -> GetCurrentWorkingDirectory() << Tendl;
  } else {
    Tcerr << head << "UserInterface doesn't exist." << Tendl;
  }
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TPrintCurrentWorkingDirectoryCommand)
#endif
