// =====================================================================
/*!
//
//  \file TCamacInterruptRegisterModule.hh
//  \brief This file contains the TCamacInterruptRegisterModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCamacInterruptRegisterModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TCamacInterruptRegisterModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCAMACINTERRUPTREGISTERMODULE_HH
#define CLDAQ__TCAMACINTERRUPTREGISTERMODULE_HH

#include "Tglobals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCamacInterruptRegisterModule
// \brief This is the TCamacInterruptRegisterModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCamacInterruptRegisterModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCamacInterruptRegisterModule
  : public TCamacModule
{

  public:
    TCamacInterruptRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch = 1, Tdata_t datalen = t16bitModule );
    TCamacInterruptRegisterModule( const TCamacInterruptRegisterModule& right );
    ~TCamacInterruptRegisterModule();

  public:
    const TCamacInterruptRegisterModule& operator=( const TCamacInterruptRegisterModule& right );
    Tbool operator==( const TCamacInterruptRegisterModule& right ) const;
    Tbool operator!=( const TCamacInterruptRegisterModule& right ) const;
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint Initialize();
    Tint ReadInterruptRegister();
    Tint ReadInterruptMaskRegister();
    Tint ClearInterruptMaskRegister();
    Tint WriteInterruptMaskRegister( Tint data );
    Tint ClearInterruptRegister();
    Tint DisableInterruptOutput();
    Tint EnableInterruptOutput();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCamacInterruptRegisterModule,0)
#endif

};

#endif
