// =====================================================================
/*!
//
//  \file TModuleTable.hh
//  \brief This file contains the TModuleTable class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TModuleTable.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TModuleTable.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TMODULETABLE_HH
#define CLDAQ__TMODULETABLE_HH

#include "Tglobals.h"
#include "TModuleSpecified.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TModuleTable
// \brief This is the TModuleTable class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TModuleTable class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TModuleTable
  : public Tvector<TModuleSpecified>
{

  public:
    TModuleTable();
    ~TModuleTable();

  public:
    TModule* FindModule( const Tstring& id ) const;
    Tvoid AddModule( TModule* module, const Tstring& id, const TstringList& groups );
    Tvoid RemoveModule( Tint index );
    Tint GetSize() const;
    Tvoid Clear();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TModuleTable,0)
#endif

};

#endif
