// =====================================================================
/*!
//
//  \file TVmeModule.hh
//  \brief This file contains the TVmeModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TVmeModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TVmeModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TVMEMODULE_HH
#define CLDAQ__TVMEMODULE_HH

#include "Tglobals.h"
#include "TModule.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TVmeModule
// \brief This is the TVmeModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TVmeModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TVmeModule
  : public TModule
{

  protected:
    Tsize_t theMappedSize;
    TvmeTransfer_t theTransferMode;
    Tint theFileDescriptor;
    Tcaddr_t theBaseAddress;
    Toff_t theOffsetAddress;

  public:
    TVmeModule( Tint nch, Toff_t offset, Tint mapsize, TvmeTransfer_t mode );
    TVmeModule( const TVmeModule& right );

  protected:
    virtual ~TVmeModule();

  public:
    virtual const TVmeModule& operator=( const TVmeModule& right );
    virtual Tbool operator==( const TVmeModule& right ) const;
    virtual Tbool operator!=( const TVmeModule& right ) const;

  public:
    Tsize_t GetMappedSize() const;
    TvmeTransfer_t GetTransferMode() const;
    Tint GetFileDescriptor() const;
    Tcaddr_t GetBaseAddress() const;
    Toff_t GetOffsetAddress() const;
    Tvoid SetMappedSize( Tsize_t mapsize );
    Tvoid SetTransferMode( TvmeTransfer_t mode );
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetBaseAddress( Tcaddr_t address );
    Tvoid SetOffsetAddress( Toff_t offset );

  protected:
    Tvoid showBit( TUshort data, const Tstring comment = "" ) const;
    Tvoid setBit( TUshort* ptr, Tint nbit, Tbit bit );
    Tbit getBit( TUshort* ptr, Tint nbit ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TVmeModule,0)
#endif

};

inline Tsize_t TVmeModule::GetMappedSize() const
{
  return theMappedSize;
}

inline TvmeTransfer_t TVmeModule::GetTransferMode() const
{
  return theTransferMode;
}

inline Tint TVmeModule::GetFileDescriptor() const
{
  return theFileDescriptor;
}

inline Tcaddr_t TVmeModule::GetBaseAddress() const
{
  return theBaseAddress;
}

inline Toff_t TVmeModule::GetOffsetAddress() const
{
  return theOffsetAddress;
}

inline Tvoid TVmeModule::SetMappedSize( Tsize_t mapsize )
{
  theMappedSize = mapsize;
  return;
}

inline Tvoid TVmeModule::SetTransferMode( TvmeTransfer_t mode )
{
  theTransferMode = mode;
  return;
}

inline Tvoid TVmeModule::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TVmeModule::SetBaseAddress( Tcaddr_t address )
{
  theBaseAddress = address;
  return;
}

inline Tvoid TVmeModule::SetOffsetAddress( Toff_t offset )
{
  theOffsetAddress = offset;
  return;
}

#endif
