// =====================================================================
//  $Id: isocket.cc,v 1.3 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: isocket.cc,v $
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectSocket.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opport( "iutput-port-number", "p", 1 );
  TArgument arg( argc, argv, TOptionTable( &opport ) );

  Tint port = 18150;
  if ( arg.HasOption( opport ) ) {
    port = arg.GetIntegerParameter( opport );
  }

  TInputObjectSocket isocket( port );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( isocket >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << isocket.GetTotalDataSize();
  Tcout << " byte data has been received." << Tendl;

  return 0;
}
