// =====================================================================
//  $Id: readout.cc,v 1.3 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: readout.cc,v $
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TOutputObjectFile.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opof( "output-record-name", 1 );
  TArgument arg( argc, argv, TOptionTable( &opof ) );

  Tstring filename = "software.drec";
  if ( arg.HasOption( opof ) ) {
    filename = arg[ opof ];
  }

  TOutputObjectFile ofile( filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TSoftwareScalerModule scaler;
  TSoftwareClockModule clock;
  TSoftwareTimerModule timer;


  // ͥɤߤξˡ
  TReadoutList list0( "LIST 0" );
  TReadoutSection sec0( "SECTION 0" );
  TReadoutSegment seg0( &scaler, "SCALER" );
  TReadoutSegment seg1( &clock, "CLOCK" );
  TReadoutSegment seg2( &timer, "TIMER" );
  sec0.push_back( seg0 );
  sec0.push_back( seg1 );
  sec0.push_back( seg2 );
  list0.push_back( sec0 );


  // ñͥɤߤξˡ 1
  TReadoutList list1( "LIST 1" );
  TReadoutSection sec1( "SECTION 1" );
  TReadoutSegment seg3( &clock, 1, "CLOCK by CHANNEL 1" );
  sec1.push_back( seg3 );
  list1.push_back( sec1 );


  // ñͥɤߤξˡ 2
  TReadoutList list2( "LIST 2" );
  TReadoutSection sec2( "SECTION 2" );
  TReadoutSegment seg4( "SEGMENT 4" );
  // CLOCK0ͥɤ,ǡID"0"ˤʤ.
  TReadoutElement ele0( &clock, "0" );
  // CLOCK4ͥɤ,ǡID"YEAR"ˤʤ.
  TReadoutElement ele1( &clock, "YEAR", 4 );
  // CLOCK5ͥɤ,ǡID"5"ˤʤ.
  TReadoutElement ele2( &clock, 5 );
  seg4.push_back( ele0 );
  seg4.push_back( ele1 );
  seg4.push_back( ele2 );
  sec2.push_back( seg4 );
  list2.push_back( sec2 );


  TBenchmark bench;
  bench.Start();

  TDataRecord record = list0.Read();
  Tcout << record << Tendl;
  ofile.Write( record );
  datasize += record.GetRecordSize();
  nevents ++;

  record = list1.Read();
  Tcout << record << Tendl;
  ofile.Write( record );
  datasize += record.GetRecordSize();
  nevents ++;

  record = list2.Read();
  Tcout << record << Tendl;
  ofile.Write( record );
  datasize += record.GetRecordSize();
  nevents ++;

  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return 0;
}
