// =====================================================================
//  $Id: Sw00RunSummary.hh,v 1.4 2004/01/19 21:10:27 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: Sw00RunSummary.hh,v $
//  Revision 1.4  2004/01/19 21:10:27  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__SW00RUNSUMMARY_HH
#define CLDAQ__SW00RUNSUMMARY_HH

#include "Tglobals.h"
#include "TRunInformationTable.hh"

class Sw00RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    Sw00RunSummary();
    ~Sw00RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint Sw00RunSummary::GetRunID() const
{
  return theRunID;
}

inline const Tstring& Sw00RunSummary::GetRecordName() const
{
  return theRecordName;
}

inline Tint Sw00RunSummary::GetRecordSize() const
{
  return theRecordSize;
}

inline Tint Sw00RunSummary::GetNumberOfEvents() const
{
  return theNumberOfEvents;
}

inline const TRunInformationTable& Sw00RunSummary::GetRunInformationTable() const
{
  return theRunInformationTable;
}

inline const Tstring& Sw00RunSummary::GetRunBeginTime() const
{
  return theRunBeginTime;
}

inline const Tstring& Sw00RunSummary::GetRunEndTime() const
{
  return theRunEndTime;
}

inline Tvoid Sw00RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid Sw00RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid Sw00RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid Sw00RunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid Sw00RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid Sw00RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid Sw00RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

#endif
