// =====================================================================
//  $Id: Sw01SystemAction.hh,v 1.3 2004/06/24 15:19:43 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: Sw01SystemAction.hh,v $
//  Revision 1.3  2004/06/24 15:19:43  goiwai
//  SystemAction::Catch()νϤʤ󤫣Ԥˤ狼Ƥ뤬Ȥꤢ֡
//
//  Revision 1.2  2004/03/04 15:11:55  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
// =====================================================================
#ifndef CLDAQ__SW01SYSTEMACTION_HH
#define CLDAQ__SW01SYSTEMACTION_HH

#include "TSystemAction.hh"

class TRunManager;
class Sw01EventDisplay;

class Sw01SystemAction
  : public TSystemAction
{

  private:
    Sw01EventDisplay* theEventDisplay;

  public:
    Sw01SystemAction();
    ~Sw01SystemAction();

  public:
    Tvoid Boot( TRunManager* manager );
    Tvoid Shutdown( TRunManager* manager );

  public:
    Sw01EventDisplay* GetEventDisplay();

  public:
    Tvoid CatchStandardOut( Tstring message );
    Tvoid CatchStandardError( Tstring message );
    Tvoid CatchLog( Tstring message, Tint level );

};

inline Sw01EventDisplay* Sw01SystemAction::GetEventDisplay()
{
  return theEventDisplay;
}

#endif
