// ============================================================================
//  $Id: TRecordDisplay.hh,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TRecordDisplay.hh,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#ifndef CLDAQ__TRECORDDISPLAY_HH
#define CLDAQ__TRECORDDISPLAY_HH

#include <TGFrame.h>
#include "Tglobals.h"
#include "TRecordDisplayComponent.hh"

class TGMainFrame;
class TRecordDisplayPreference;
class TRecordAssociationTable;
class TH1D;
class TRootEmbeddedCanvas;
class TApplication;
class TRecordDisplayCanvas;
class TRecordDisplayTab;
class TDirectory;
class TRecordDisplayMenuBar;


// ߥåȤޤޤޤȤưƤʤǤ
// ͷ٤˹ͤޤ礦
// TODO񤤤Ƥޤ
// 
// ¿Υ᥽åɤޤOpen(),SaveAs(),Pause()Ƥޤ
//   ä˾֤򥳥ȥ褦
//   Start(),Pause(),Stop(),Update()Ϥä
//   Pause(),Stop()Ĥ
//   ˼Start()򤤤ɬפ
// Preferences()
//   ưŪѹ褦
//   ꥭХư
//   ⤦Ƥ¿Ƥ⤤
// TRecordAssociation
//   ⤦䤷Ƥ褤
// ViewطΥ᥽åɤϸ
// ưŪ˥ե(*.drec)ꤷ,ɽ
// Initialize()
//   ˥塼СĤä褦
//   ¿Υ꡼̵
// ꡼
//   TRecordDisplayTab,TRecordDisplayMenuBar ȯ
// Event DisplayȤƤλȤΥ᡼
//   SystemBegin new
//     RunBegin -> Initialize()
//       EventBeginHash
//       EventEndǥեȤ
//     RunEndǥ֤
//   SystemEndTerminate


class TRecordDisplay
  : public TRecordDisplayComponent, public TGMainFrame
{

  public:
    enum {
      MENU_FILE_OPEN,
      MENU_FILE_BROWSE,
      MENU_FILE_SAVE,
      MENU_FILE_SAVEAS,
      MENU_FILE_PRINT,
      MENU_FILE_PRINTAS,
      MENU_FILE_QUIT,

      MENU_CTRL_START,
      MENU_CTRL_PAUSE,
      MENU_CTRL_UPDATE,
      MENU_CTRL_STOP,

      MENU_EDIT_EDIT,
      MENU_EDIT_UNDO,
      MENU_EDIT_CLEAR,
      MENU_EDIT_INITIALIZE,
      MENU_EDIT_PREFERENCES,

      MENU_VIEW_FULL_SCREEN,
      MENU_VIEW_ICONIFY,
      MENU_VIEW_COLOR_LIST,
      MENU_VIEW_FONT_LIST,
      MENU_VIEW_MARKER_LIST,
      MENU_VIEW_X3D,
      MENU_VIEW_OPEN_GL,

      N_MESSAGE_ID
    };

  private:
    static TApplication* theApplication;

  private:
    TRecordDisplayPreference* thePreference;
    TRecordAssociationTable* theAssociationTable;
    Tint theNumberOfRecords;
    Tbool theAutoBuild;
    TRecordDisplayTab* theTab;
    TRecordDisplayMenuBar* theMenu;

  public:
    TRecordDisplay();
    TRecordDisplay( const Tstring& filename, TRecordAssociationTable* as = 0 );
    TRecordDisplay( TRecordDisplayPreference* pre, const Tstring& filename, TRecordAssociationTable* as = 0 );
    TRecordDisplay( TRecordDisplayPreference* pre, TRecordAssociationTable* as = 0 );
    ~TRecordDisplay();

  public:
    // File Menu
    Tvoid Open();
    Tvoid Browse();
    Tvoid Save();
    Tvoid SaveAs();
    Tvoid Print();
    Tvoid PrintAs();
    Tvoid Quit();

    // Control Menu
    Tvoid Start();
    Tvoid Start( const Tstring& filename );
    Tvoid Pause();
    Tvoid Update();
    Tvoid Stop();

    // Edit Menu
    Tvoid Edit();
    Tvoid Undo();
    Tvoid Clear();
    Tvoid Initialize();
    Tvoid Preferences();

  public:
    Tvoid Associate();
    Tvoid AutoBuild();
    Tvoid Build();
    TDirectory* GetDirectory( Tstring* tags );
    Tstring GetHistogramName( Tint id ) const;
    Tstring GetCanvasName( Tint id ) const;
    Tvoid BuildMenuBar();
    Tvoid BuildTabFrame();
    TGCompositeFrame* GetFrame( Tstring* tags );

  public:
    const TRecordDisplayPreference* GetPreference() const;
    const TRecordAssociationTable* GetAssociationTable() const;
    Tint GetNumberOfRecords() const;
    Tbool IsAutoBuild() const;
    Tbool ProcessMessage( Tlong msg, Tlong id, Tlong arg );

  public:
    static TApplication* GetApplication();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRecordDisplay,0)
#endif

};

inline TApplication* TRecordDisplay::GetApplication()
{
  return theApplication;
}

inline const TRecordDisplayPreference* TRecordDisplay::GetPreference() const
{
  return thePreference;
}

inline const TRecordAssociationTable* TRecordDisplay::GetAssociationTable() const
{
  return theAssociationTable;
}

inline Tint TRecordDisplay::GetNumberOfRecords() const
{
  return theNumberOfRecords;
}

inline Tbool TRecordDisplay::IsAutoBuild() const
{
  return theAutoBuild;
}

#endif
#endif
