// =====================================================================
//  $Id: TRunEventLimitCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TRunEventLimitCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunEventLimitCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/eventlimit";
static const Tstring _desc = "set number of events taken in this run.\nif you want to cancel this limit, set to 0 or less.\nexample> /run/eventlimit 100";

TRunEventLimitCommand::TRunEventLimitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunEventLimitCommand::~TRunEventLimitCommand()
{;}

Tvoid TRunEventLimitCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    Tcout << theRunManager -> GetEventLimit() << Tendl;
  } else if ( arguments.size() == 1 ) {
    Tint nevents = strtol( arguments[ 0 ].c_str(), 0, 0 );
    theRunManager -> SetEventLimit( nevents );
  } else {
    ShowCommandDetail();
  }

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRunEventLimitCommand)
#endif
