// =====================================================================
//  $Id: TSetStackSizeCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TSetStackSizeCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSetStackSizeCommand.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"

static const Tstring _name = "/event/stacksize";
static const Tstring _desc = "set stack size.\nexample> /event/stacksize\nexample> /event/stacksize 1234";

TSetStackSizeCommand::TSetStackSizeCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSetStackSizeCommand::~TSetStackSizeCommand()
{;}

Tvoid TSetStackSizeCommand::Execute( const TstringList& arguments )
{
  TEventManager* manager = theRunManager -> GetEventManager();

  if ( arguments.empty() ) {
    Tcout << manager -> GetStackSize() << Tendl;
  } else {
    if ( arguments.size() == 1 ) {
      Tstring stacksize = arguments[ 0 ];
      manager -> SetStackSize( strtol( stacksize.c_str(), 0, 0 ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TSetStackSizeCommand)
#endif
