// =====================================================================
/*!
//
//  \file TDataSection.hh
//  \brief This file contains the TDataSection class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDataSection.hh,v 1.10 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TDataSection.hh,v $
//  Revision 1.10  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.9  2004/01/19 21:09:39  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.8  2003/12/06 10:59:11  goiwai
//  Serialize(Tvoid*) -> Serialize(const Tvoid*)ѹޤ.
//  Deserialize(const Tvoid*)ɲäޤ.
//  ȴμʤΤ,ХåեСեβǽޤ.
//  Reallocate()Ȥ褦ʻȤߤɬפǤ.
//
//  Revision 1.7  2003/11/24 06:56:13  goiwai
//  Size()дؿɲäޤ.
//  ƤDataSegmentο֤ޤ.
//
//  Revision 1.6  2003/11/04 12:03:05  goiwai
//  ==黻Ҥ!=黻Ҥޤ.Ūˤ
//  if ( record == "String" ) {
//    hoeghoge;
//  }
//  Τ褦ʻȤޤ.ñ theID ФȤӤƷ̤֤ޤ.
//
//  Revision 1.5  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:42:19  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/08/25 09:20:29  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  record[0] Ȥ record["tag"] Ȥ, TDataSegment 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataSegment ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TDATASECTION_HH
#define CLDAQ__TDATASECTION_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataSegmentList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDataSection
// \brief This is the TDataSection class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDataSection class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup DatarecordCategory
*/
class TDataSection
  : public TStreamableObject, public TDataSegmentList
{

  public:
    TDataSection( const Tstring& id = TunknownID );
    TDataSection( const TDataSection& right );  
    ~TDataSection();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* objectfile );
    Tvoid Clear();
    Tint Serialize( const Tvoid* buffer );
    Tint Deserialize( const Tvoid* buffer );
    Tint Size() const;

  public:
    const TDataSection& operator=( const TDataSection& right );
    Tbool operator==( const TDataSection& right ) const;
    Tbool operator!=( const TDataSection& right ) const;
    Tbool operator==( const Tstring& right ) const;
    Tbool operator!=( const Tstring& right ) const;
    const TDataSegment& operator[]( Tint n ) const;
    TDataSegment& operator[]( Tint n );
    const TDataSegment& operator[]( const Tstring& id ) const;
    TDataSegment& operator[]( const Tstring& id );
    friend Tostream& operator<<( Tostream& tos, const TDataSection& right );

  public:
    Tbool FindDataSegment( const Tstring& id, TDataSegment& segment ) const;
    Tint FindDataSegment( const Tstring& id ) const;
    Tbool FindDataElement( const Tstring& segid, const Tstring& eleid, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& segid, const Tstring& eleid ) const;
    Tbool FindDataElement( Tstring idset[ 2 ], TDataElement& element ) const;
    Tint FindDataElement( Tstring idset[ 2 ] ) const;
    Tbool FindDataElement( const TstringList& idset, TDataElement& element ) const;
    Tint FindDataElement( const TstringList& idset ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TDataSection,0)
#endif

};

inline Tint TDataSection::Size() const
{
  return (Tint)size();
}

#endif
