// =====================================================================
/*!
//
//  \file TEventManager.hh
//  \brief This file contains the TEventManager class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TEventManager.hh,v 1.8 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TEventManager.hh,v $
//  Revision 1.8  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.7  2004/03/04 14:53:43  goiwai
//  BeginOfEventAction -> AtFirst
//  EndOfEventAction -> AtLast
//  WaitEvent -> WaitTrigger
//
//  Revision 1.6  2004/01/19 21:09:40  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:50:25  goiwai
//  äȤ狼Ť餤ͤʤǤ,CLDAQǤϥ٥ȥåRun
//  ֥Ȥޤ.Υ٥ȥåؤΥ᥽åɤ
//  EventManagerɲäޤ.
//  ưȤƤϥꥢ,,ǿΥ٥,Υ٥,Υ٥Ȥμ
//  Ǥ.
//  ٥ȥޥ͡㡼̤ƥåΥ٥Ȥ뤿Ӥ,
//  ΥҥȥϹޤ.LastEventȤNextEventȤΤϤΥҥ
//  򸫤Event֤Ƥޤ.å­ʤƤǤŪΥ
//  Ȥ¸ߤʤȤEventID=-1Event֤äƤޤ.
//
//  Revision 1.3  2003/07/30 16:18:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TEVENTMANAGER_HH
#define CLDAQ__TEVENTMANAGER_HH

#include "Tglobals.h"
#include "TEvent.hh"
//#include "TSystemTimer.hh"

class TRun;
class TEventAction;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TEventManager
// \brief This is the TEventManager class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TEventManager class detail description.
// Write it down ASAP!
//
// \todo ȥꥬԤǥॢȽΤǤĤ٤?
// \bug None?
// \ingroup EventCategory
*/
class TEventManager
{

  private:
    static TEventManager* theEventManager;

  public:
    enum { tDefaultStackSize = 100 };

  private:
    Tstatus_t theStatus;
    Tint theStackSize;
    Tint theNumberOfEvents;
    TEventAction* theEventAction;
    TEvent theEvent;
    //TSystemTimer theEventTimer;
    Tint theLastAccessID;

  public:
    TEventManager( Tint stacksize = tDefaultStackSize );
    virtual ~TEventManager();

  public:
    Tint GetStackSize() const;
    Tint GetNumberOfEvents() const;
    const TEvent& GetEvent() const;
    TEvent& GetEvent();
    TEventAction* GetEventAction() const;
    Tvoid SetStackSize( Tint stacksize );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetEvent( const TEvent& event );
    Tvoid SetEventAction( TEventAction* action );
    Tstatus_t GetStatus() const;
    Tvoid SetStatus( Tstatus_t status );
    //const TSystemTimer& GetEventTimer() const;
    //TSystemTimer& GetEventTimer();
    //Tvoid SetEventTimer( const TSystemTimer& timer );
    Tint GetLastAccessID() const;
    Tvoid SetLastAccessID( Tint id );

  public:
    Tvoid ClearEventStack();
    Tint FindEvent( Tint id ) const;
    Tbool HasEvent( Tint id ) const;
    Tvoid TouchNewestEvent();
    TEvent GetNewestEvent();
    TEvent GetNextEvent();
    TEvent GetLastEvent();
    TEvent GetEvent( Tint id );

  public:
    virtual const TRun& RecordEvent();
    virtual const TEvent& TakeEvent();
    virtual Tvoid ShowStatus() const;
    virtual Tvoid Clear();

  public:
    static TEventManager* GetEventManager();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TEventManager,0)
#endif

};

inline TEventManager* TEventManager::GetEventManager()
{
  return theEventManager;
}

inline Tint TEventManager::GetStackSize() const
{
  return theStackSize;
}

inline Tint TEventManager::GetNumberOfEvents() const
{
  return theNumberOfEvents;
}

inline const TEvent& TEventManager::GetEvent() const
{
  return theEvent;
}

inline TEvent& TEventManager::GetEvent()
{
  return theEvent;
}

inline TEventAction* TEventManager::GetEventAction() const
{
  return theEventAction;
}

inline Tvoid TEventManager::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid TEventManager::SetEvent( const TEvent& event )
{
  theEvent = event;
  return;
}

inline Tstatus_t TEventManager::GetStatus() const
{
  return theStatus;
}

inline Tvoid TEventManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

// inline const TSystemTimer& TEventManager::GetEventTimer() const
// {
//   return theEventTimer;
// }

// inline TSystemTimer& TEventManager::GetEventTimer()
// {
//   return theEventTimer;
// }

// inline Tvoid TEventManager::SetEventTimer( const TSystemTimer& timer )
// {
//   theEventTimer = timer;
//   return;
// }

inline Tint TEventManager::GetLastAccessID() const
{
  return theLastAccessID;
}

inline Tvoid TEventManager::SetLastAccessID( Tint id )
{
  theLastAccessID = id;
  return;
}

#endif
