// =====================================================================
/*!
//
//  \file TSoftwareClockModule.hh
//  \brief This file contains the TSoftwareClockModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareClockModule.hh,v 1.7 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TSoftwareClockModule.hh,v $
//  Revision 1.7  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSOFTWARECLOCKMODULE_HH
#define CLDAQ__TSOFTWARECLOCKMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"
#include "TSystemClock.hh"

class TDataElement;
class TSystemClock;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareClockModule
// \brief This is the TSoftwareClockModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareClockModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareClockModule
  : public TSoftwareModule
{
  public:
    enum { 
      tStringTime,
      tIntegerTime,
      tElapsedTimeOfLastInitialize,
      tElapsedTimeOfLastUpdate,
      tYear,
      tMonth,
      tDay,
      tHour,
      tMinute,
      tSecond,
      tNumberOfChannels
    };

  private:
    TSystemClock theSystemClock;

  public:
    TSoftwareClockModule( Tint nchannel = tNumberOfChannels );
    TSoftwareClockModule( const TSoftwareClockModule& right );
    ~TSoftwareClockModule();

  public:
    const TSoftwareClockModule& operator=( const TSoftwareClockModule& right );
    Tbool operator==( const TSoftwareClockModule& right ) const;
    Tbool operator!=( const TSoftwareClockModule& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSystemClock& GetSystemClock() const;
    TSystemClock& GetSystemClock();
    Tvoid SetSystemClock( const TSystemClock& clock );

  public:
    Tstring GetStringTime();
    Tint GetIntegerTime();
    Tstring WhatTimeIsItNow();
    Tstring WhatTimeIsIt( Tint second = -1 );
    Tint GetElapsedTimeOfLastInitialize( const Tstring& unit = Tsec );
    Tint GetElapsedTimeOfLastUpdate( const Tstring& unit = Tsec );
    Tint GetYear();
    Tint GetMonth();
    Tint GetDay();
    Tint GetHour();
    Tint GetMinute();
    Tint GetSecond();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSoftwareClockModule,0)
#endif

};

inline const TSystemClock& TSoftwareClockModule::GetSystemClock() const
{
  return theSystemClock;
}

inline TSystemClock& TSoftwareClockModule::GetSystemClock()
{
  return theSystemClock;
}

inline Tvoid TSoftwareClockModule::SetSystemClock( const TSystemClock& clock )
{
  theSystemClock = clock;
  return;
}

inline Tstring TSoftwareClockModule::GetStringTime()
{
  return theSystemClock.WhatTimeIsItNow();
}

inline Tint TSoftwareClockModule::GetIntegerTime()
{
  theSystemClock.Update();
  return theSystemClock.GetTime();
}

inline Tstring TSoftwareClockModule::WhatTimeIsItNow()
{
  return theSystemClock.WhatTimeIsItNow();
}

inline Tstring TSoftwareClockModule::WhatTimeIsIt( Tint second )
{
  return theSystemClock.WhatTimeIsIt( second );
}

inline Tint TSoftwareClockModule::GetYear()
{
  return theSystemClock.GetYear();
}

inline Tint TSoftwareClockModule::GetMonth()
{
  return theSystemClock.GetMonth();
}

inline Tint TSoftwareClockModule::GetDay()
{
  return theSystemClock.GetDay();
}

inline Tint TSoftwareClockModule::GetHour()
{
  return theSystemClock.GetHour();
}

inline Tint TSoftwareClockModule::GetMinute()
{
  return theSystemClock.GetMinute();
}

inline Tint TSoftwareClockModule::GetSecond()
{
  return theSystemClock.GetSecond();
}

inline Tint TSoftwareClockModule::GetElapsedTimeOfLastInitialize( const Tstring& unit )
{
  return theSystemClock.GetElapsedTime( unit );
}

inline Tint TSoftwareClockModule::GetElapsedTimeOfLastUpdate( const Tstring& unit )
{
  return theSystemClock.GetElapsedTimeOfLastUpdate( unit );
}

#endif
