// =====================================================================
/*!
//
//  \file TOutputObjectStream.hh
//  \brief This file contains the TOutputObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputObjectStream.hh,v 1.7 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TOutputObjectStream.hh,v $
//  Revision 1.7  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOUTPUTOBJECTSTREAM_HH
#define CLDAQ__TOUTPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TOutputObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputObjectStream
// \brief This is the TOutputObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TOutputObjectStream
  : public TObjectStream
{

  protected:
    TOutputObjectFilter* theObjectFilter;

  public:
    TOutputObjectStream( Tstream_t streamtype = tUnknownStream );
    TOutputObjectStream( TOutputObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TOutputObjectStream();

  public:
    TOutputObjectFilter* GetObjectFilter() const;
    Tvoid SetObjectFilter( TOutputObjectFilter* filter );
    Tbool HasFilter() const;

  public:
    virtual Tint Write( TStreamableObject& object ) = 0;
    friend Tint operator<<( TOutputObjectStream& left, TStreamableObject& object );
    friend Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOutputObjectStream,0)
#endif

};

inline Tint operator<<( TOutputObjectStream& left, TStreamableObject& object )
{
  return left.Write( object );
}

inline Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object )
{
  return left.Write( *(TStreamableObject*)(&object) );
}

inline TOutputObjectFilter* TOutputObjectStream::GetObjectFilter() const
{
  return theObjectFilter;
}

inline Tvoid TOutputObjectStream::SetObjectFilter( TOutputObjectFilter* filter )
{
  theObjectFilter = filter;
  return;
}

inline Tbool TOutputObjectStream::HasFilter() const
{
  return ( theObjectFilter != 0 ) ? Ttrue : Tfalse;
}

#endif
